/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.MutableResultsColumns;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableTable;
import schemacrawler.schema.ResultsColumns;
import sf.util.Utility;

final class ResultsRetriever
extends AbstractRetriever {
    private final ResultSetMetaData resultsMetaData;

    ResultsRetriever(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new SQLException("Cannot retrieve metadata for null results");
        }
        this.resultsMetaData = resultSet.getMetaData();
    }

    ResultsColumns retrieveResults() throws SQLException {
        MutableResultsColumns resultColumns = new MutableResultsColumns("");
        MutableDatabase database = new MutableDatabase("results");
        int columnCount = this.resultsMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String catalogName = this.resultsMetaData.getCatalogName(i);
            String schemaName = this.resultsMetaData.getSchemaName(i);
            String tableName = this.resultsMetaData.getTableName(i);
            if (Utility.isBlank(tableName)) {
                tableName = "";
            }
            MutableSchema schema = database.addSchema(catalogName, schemaName);
            MutableTable table2 = new MutableTable(schema, tableName);
            schema.addTable(table2);
            String databaseSpecificTypeName = this.resultsMetaData.getColumnTypeName(i);
            MutableColumnDataType columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
            columnDataType.setType(this.resultsMetaData.getColumnType(i), this.resultsMetaData.getColumnClassName(i));
            columnDataType.setPrecision(this.resultsMetaData.getPrecision(i));
            int scale = this.resultsMetaData.getScale(i);
            columnDataType.setMaximumScale(scale);
            columnDataType.setMinimumScale(scale);
            String columnName2 = this.resultsMetaData.getColumnName(i);
            MutableResultsColumn column = new MutableResultsColumn(table2, columnName2);
            column.setOrdinalPosition(i);
            column.setType(columnDataType);
            column.setLabel(this.resultsMetaData.getColumnLabel(i));
            column.setDisplaySize(this.resultsMetaData.getColumnDisplaySize(i));
            boolean isNullable = this.resultsMetaData.isNullable(i) == 1;
            column.setAutoIncrement(this.resultsMetaData.isAutoIncrement(i));
            column.setCaseSensitive(this.resultsMetaData.isCaseSensitive(i));
            column.setCurrency(this.resultsMetaData.isCurrency(i));
            column.setDefinitelyWritable(this.resultsMetaData.isDefinitelyWritable(i));
            column.setNullable(isNullable);
            column.setReadOnly(this.resultsMetaData.isReadOnly(i));
            column.setSearchable(this.resultsMetaData.isSearchable(i));
            column.setSigned(this.resultsMetaData.isSigned(i));
            column.setWritable(this.resultsMetaData.isWritable(i));
            resultColumns.addColumn(column);
        }
        return resultColumns;
    }
}

