/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.NamedObjectSort;
import schemacrawler.crawl.ProcedureExRetriever;
import schemacrawler.crawl.ProcedureRetriever;
import schemacrawler.crawl.ResultsRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.SchemaReference;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.TableExRetriever;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.schema.Column;
import schemacrawler.schema.Database;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;

public final class SchemaCrawler {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawler.class.getName());
    private final Connection connection;

    public static ResultsColumns getResultColumns(ResultSet resultSet) {
        ResultsColumns resultColumns = null;
        try {
            ResultsRetriever resultsRetriever = new ResultsRetriever(resultSet);
            resultColumns = resultsRetriever.retrieveResults();
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, e2.getMessage(), e2);
            resultColumns = null;
        }
        return resultColumns;
    }

    private static void crawlColumnDataTypes(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, database);
            if (infoLevel.isRetrieveColumnDataTypes()) {
                retriever.retrieveSystemColumnDataTypes();
            }
            if (infoLevel.isRetrieveUserDefinedColumnDataTypes()) {
                for (SchemaReference schemaNameObject : retriever.getSchemaNames()) {
                    retriever.retrieveUserDefinedColumnDataTypes(schemaNameObject.getSchemaName(), schemaNameObject.getSchemaName());
                }
            }
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Exception retrieving column data type information", e2);
        }
    }

    private static void crawlDatabaseInfo(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, database);
            if (infoLevel.isRetrieveSchemaCrawlerInfo()) {
                retriever.retrieveSchemaCrawlerInfo();
                if (infoLevel.isRetrieveAdditionalSchemaCrawlerInfo()) {
                    retriever.retrieveAdditionalSchemaCrawlerInfo();
                }
            }
            if (infoLevel.isRetrieveDatabaseInfo()) {
                retriever.retrieveDatabaseInfo();
                if (infoLevel.isRetrieveAdditionalDatabaseInfo()) {
                    retriever.retrieveAdditionalDatabaseInfo();
                }
            }
            if (infoLevel.isRetrieveJdbcDriverInfo()) {
                retriever.retrieveJdbcDriverInfo();
                if (infoLevel.isRetrieveAdditionalJdbcDriverInfo()) {
                    retriever.retrieveAdditionalJdbcDriverInfo();
                }
            }
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Exception retrieving database information", e2);
        }
    }

    private static void crawlProcedures(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        boolean retrieveProcedures;
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean bl = retrieveProcedures = options.isShowStoredProcedures() && infoLevel.isRetrieveProcedures();
        if (!retrieveProcedures) {
            return;
        }
        try {
            ProcedureRetriever retriever = new ProcedureRetriever(retrieverConnection, database);
            ProcedureExRetriever retrieverExtra = new ProcedureExRetriever(retrieverConnection, database);
            for (SchemaReference schemaNameObject : retriever.getSchemaNames()) {
                retriever.retrieveProcedures(schemaNameObject.getCatalogName(), schemaNameObject.getSchemaName(), options.getProcedureInclusionRule());
            }
            NamedObjectList<MutableProcedure> allProcedures = database.getAllProcedures();
            for (MutableProcedure procedure : allProcedures) {
                if (infoLevel.isRetrieveProcedureColumns()) {
                    retriever.retrieveProcedureColumns(procedure, options.getProcedureColumnInclusionRule());
                }
                if (SchemaCrawler.grepMatch(options, procedure)) continue;
                ((MutableSchema)procedure.getSchema()).removeProcedure(procedure);
                allProcedures.remove(procedure);
            }
            if (infoLevel.isRetrieveProcedureInformation()) {
                retrieverExtra.retrieveProcedureInformation();
            }
            for (MutableProcedure procedure : allProcedures) {
                procedure.setColumnComparator(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForProcedureColumns()));
            }
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Exception retrieving procedures", e2);
        }
    }

    private static void crawlSchemas(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaRetriever retriever = new SchemaRetriever(retrieverConnection, database);
            retriever.retrieveSchemas(options.getSchemaInclusionRule());
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Exception retrieving database information", e2);
        }
    }

    private static void crawlTables(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveTables = infoLevel.isRetrieveTables();
        if (!retrieveTables) {
            return;
        }
        try {
            NamedObjectSort tablesSort;
            TableRetriever retriever = new TableRetriever(retrieverConnection, database);
            TableExRetriever retrieverExtra = new TableExRetriever(retrieverConnection, database);
            for (SchemaReference schemaNameObject : retriever.getSchemaNames()) {
                retriever.retrieveTables(schemaNameObject.getCatalogName(), schemaNameObject.getSchemaName(), options.getTableNamePattern(), options.getTableTypes(), options.getTableInclusionRule());
            }
            NamedObjectList<MutableTable> allTables = database.getAllTables();
            for (MutableTable table2 : allTables) {
                if (infoLevel.isRetrieveTableColumns()) {
                    retriever.retrieveColumns(table2, options.getColumnInclusionRule());
                }
                if (SchemaCrawler.grepMatch(options, table2)) continue;
                ((MutableSchema)table2.getSchema()).removeTable(table2);
                allTables.remove(table2);
            }
            if (infoLevel.isRetrieveCheckConstraintInformation()) {
                retrieverExtra.retrieveCheckConstraintInformation();
            }
            if (infoLevel.isRetrieveTriggerInformation()) {
                retrieverExtra.retrieveTriggerInformation();
            }
            if (infoLevel.isRetrieveViewInformation()) {
                retrieverExtra.retrieveViewInformation();
            }
            if (infoLevel.isRetrieveTablePrivileges()) {
                retrieverExtra.retrieveTablePrivileges();
            }
            if (infoLevel.isRetrieveTableColumnPrivileges()) {
                retrieverExtra.retrieveTableColumnPrivileges();
            }
            if ((tablesSort = NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForTables())) == NamedObjectSort.natural && !infoLevel.isRetrieveForeignKeys()) {
                LOGGER.log(Level.WARNING, "Foreign-keys are not being retrieved, so tables cannot be sorted using the natural sort order");
            }
            for (MutableTable table3 : allTables) {
                boolean isView = table3 instanceof MutableView;
                if (!isView && infoLevel.isRetrieveTableColumns()) {
                    retriever.retrievePrimaryKey(table3);
                    if (infoLevel.isRetrieveIndices()) {
                        retriever.retrieveIndices(table3, true);
                        retriever.retrieveIndices(table3, false);
                        table3.replacePrimaryKey();
                    }
                    if (infoLevel.isRetrieveForeignKeys()) {
                        retriever.retrieveForeignKeys(table3);
                    }
                }
                ((MutableSchema)table3.getSchema()).setTablesSortOrder(tablesSort);
                table3.setColumnsSortOrder(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForTableColumns()));
                table3.setForeignKeysSortOrder(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForForeignKeys()));
                table3.setIndicesSortOrder(NamedObjectSort.getNamedObjectSort(options.isAlphabeticalSortForIndexes()));
            }
            allTables.setSortOrder(tablesSort);
            TablesGraph tablesGraph = new TablesGraph(allTables);
            tablesGraph.setTablesSortIndices();
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Exception retrieving tables", e2);
        }
    }

    private static boolean grepMatch(SchemaCrawlerOptions options, Procedure procedure) {
        InclusionRule grepProcedureColumnInclusionRule = options.getGrepProcedureColumnInclusionRule();
        boolean invertMatch = options.isGrepInvertMatch();
        boolean include2 = false;
        ProcedureColumn[] columns2 = procedure.getColumns();
        if (columns2.length == 0) {
            include2 = true;
        } else {
            for (ProcedureColumn column : columns2) {
                if (!grepProcedureColumnInclusionRule.include(column.getFullName())) continue;
                include2 = true;
                break;
            }
        }
        if (invertMatch) {
            boolean bl = include2 = !include2;
        }
        if (!include2) {
            LOGGER.log(Level.FINE, "Removing procedure " + procedure + " since it does not match the grep pattern");
        }
        return include2;
    }

    private static boolean grepMatch(SchemaCrawlerOptions options, Table table2) {
        InclusionRule grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        boolean invertMatch = options.isGrepInvertMatch();
        boolean include2 = false;
        Column[] columns2 = table2.getColumns();
        if (columns2.length == 0) {
            include2 = true;
        } else {
            for (Column column : columns2) {
                if (!grepColumnInclusionRule.include(column.getFullName())) continue;
                include2 = true;
                break;
            }
        }
        if (invertMatch) {
            boolean bl = include2 = !include2;
        }
        if (!include2) {
            LOGGER.log(Level.FINE, "Removing table " + table2 + " since it does not match the grep pattern");
        }
        return include2;
    }

    public SchemaCrawler(Connection connection) throws SchemaCrawlerException {
        if (connection == null) {
            throw new SchemaCrawlerException("No connection specified");
        }
        this.connection = connection;
    }

    public Database crawl(SchemaCrawlerOptions options) throws SchemaCrawlerException {
        MutableDatabase database = new MutableDatabase("database");
        RetrieverConnection retrieverConnection = null;
        try {
            SchemaCrawlerOptions schemaCrawlerOptions = options;
            if (schemaCrawlerOptions == null) {
                schemaCrawlerOptions = new SchemaCrawlerOptions();
            }
            retrieverConnection = new RetrieverConnection(this.connection, schemaCrawlerOptions);
            SchemaCrawler.crawlSchemas(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlDatabaseInfo(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlColumnDataTypes(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlTables(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlProcedures(database, retrieverConnection, schemaCrawlerOptions);
            return database;
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Database access exception", e2);
        }
    }
}

