/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCheckConstraint;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class TableExRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableExRetriever.class.getName());

    TableExRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    private void createPrivileges(MetadataResultSet results2, boolean privilegesForColumn) throws SQLException {
        while (results2.next()) {
            MutablePrivilege privilege;
            String catalogName = this.quotedName(results2.getString("TABLE_CAT"));
            String schemaName = this.quotedName(results2.getString("TABLE_SCHEM"));
            String tableName = this.quotedName(results2.getString("TABLE_NAME"));
            String columnName2 = privilegesForColumn ? this.quotedName(results2.getString("COLUMN_NAME")) : null;
            MutableTable table2 = this.lookupTable(catalogName, schemaName, tableName);
            if (table2 == null) continue;
            MutableColumn column = table2.getColumn(columnName2);
            if (privilegesForColumn && column == null) continue;
            String privilegeName = results2.getString("PRIVILEGE");
            String grantor = results2.getString("GRANTOR");
            String grantee = results2.getString("GRANTEE");
            boolean isGrantable = results2.getBoolean("IS_GRANTABLE");
            if (privilegesForColumn) {
                MutablePrivilege columnPrivilege = column.getPrivilege(privilegeName);
                if (columnPrivilege == null) {
                    privilege = new MutablePrivilege(column, privilegeName);
                    column.addPrivilege(privilege);
                } else {
                    privilege = columnPrivilege;
                }
            } else {
                MutablePrivilege tablePrivilege = table2.getPrivilege(privilegeName);
                if (tablePrivilege == null) {
                    privilege = new MutablePrivilege(table2, privilegeName);
                    table2.addPrivilege(privilege);
                } else {
                    privilege = tablePrivilege;
                }
            }
            privilege.addGrant(grantor, grantee, isGrantable);
            privilege.addAttributes(results2.getAttributes());
            if (privilegesForColumn) {
                column.addPrivilege(privilege);
                continue;
            }
            table2.addPrivilege(privilege);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveCheckConstraintInformation() throws SQLException {
        MutableTable table2;
        HashMap<String, MutableCheckConstraint> checkConstraintsMap = new HashMap<String, MutableCheckConstraint>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTableConstraintsSql()) {
            LOGGER.log(Level.FINE, "Table constraints SQL statement was not provided");
            return;
        }
        String tableConstraintsInformationSql = informationSchemaViews.getTableConstraints();
        Connection connection = this.getDatabaseConnection();
        Statement statement = null;
        MetadataResultSet results2 = null;
        try {
            statement = connection.createStatement();
            results2 = new MetadataResultSet(statement.executeQuery(tableConstraintsInformationSql));
            while (results2.next()) {
                String catalogName = this.quotedName(results2.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.quotedName(results2.getString("CONSTRAINT_SCHEMA"));
                String constraintName = this.quotedName(results2.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint: " + constraintName);
                String tableName = this.quotedName(results2.getString("TABLE_NAME"));
                table2 = this.lookupTable(catalogName, schemaName, tableName);
                if (table2 == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                String constraintType = results2.getString("CONSTRAINT_TYPE");
                boolean deferrable = results2.getBoolean("IS_DEFERRABLE");
                boolean initiallyDeferred = results2.getBoolean("INITIALLY_DEFERRED");
                if (!constraintType.equalsIgnoreCase("check")) continue;
                MutableCheckConstraint checkConstraint = new MutableCheckConstraint(table2, constraintName);
                checkConstraint.setDeferrable(deferrable);
                checkConstraint.setInitiallyDeferred(initiallyDeferred);
                checkConstraint.addAttributes(results2.getAttributes());
                checkConstraintsMap.put(constraintName, checkConstraint);
            }
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraint information", e2);
            return;
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        if (!informationSchemaViews.hasCheckConstraintsSql()) {
            LOGGER.log(Level.FINE, "Check constraints SQL statement was not provided");
            return;
        }
        String checkConstraintInformationSql = informationSchemaViews.getCheckConstraints();
        statement = null;
        results2 = null;
        try {
            statement = connection.createStatement();
            results2 = new MetadataResultSet(statement.executeQuery(checkConstraintInformationSql));
            while (results2.next()) {
                String constraintName = this.quotedName(results2.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint definition: " + constraintName);
                String definition = results2.getString("CHECK_CLAUSE");
                MutableCheckConstraint checkConstraint = (MutableCheckConstraint)checkConstraintsMap.get(constraintName);
                if (checkConstraint == null) {
                    LOGGER.log(Level.FINEST, "Could not add check constraint to table: " + constraintName);
                    continue;
                }
                String text2 = checkConstraint.getDefinition();
                if (text2 != null && text2.trim().length() != 0) {
                    definition = checkConstraint.getDefinition() + definition;
                }
                checkConstraint.setDefinition(definition);
            }
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        Collection checkConstraintsCollection = checkConstraintsMap.values();
        for (MutableCheckConstraint checkConstraint : checkConstraintsCollection) {
            table2 = (MutableTable)checkConstraint.getParent();
            table2.addCheckConstraint(checkConstraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTableColumnPrivileges() throws SQLException {
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getColumnPrivileges(null, null, "%", "%"));
            this.createPrivileges(results2, true);
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Could not retrieve table column privileges:" + e2.getMessage());
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTablePrivileges() throws SQLException {
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getTablePrivileges(null, null, "%"));
            this.createPrivileges(results2, false);
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Could not retrieve table privileges", e2);
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTriggerInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTriggerSql()) {
            LOGGER.log(Level.FINE, "Trigger definition SQL statement was not provided");
            return;
        }
        String triggerInformationSql = informationSchemaViews.getTriggers();
        Connection connection = this.getDatabaseConnection();
        Statement statement = connection.createStatement();
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(statement.executeQuery(triggerInformationSql));
            while (results2.next()) {
                String catalogName = this.quotedName(results2.getString("TRIGGER_CATALOG"));
                String schemaName = this.quotedName(results2.getString("TRIGGER_SCHEMA"));
                String triggerName = this.quotedName(results2.getString("TRIGGER_NAME"));
                LOGGER.log(Level.FINER, "Retrieving trigger: " + triggerName);
                String tableName = results2.getString("EVENT_OBJECT_TABLE");
                MutableTable table2 = this.lookupTable(catalogName, schemaName, tableName);
                if (table2 == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                EventManipulationType eventManipulationType = results2.getEnum("EVENT_MANIPULATION", EventManipulationType.unknown);
                int actionOrder = results2.getInt("ACTION_ORDER", 0);
                String actionCondition = results2.getString("ACTION_CONDITION");
                String actionStatement = results2.getString("ACTION_STATEMENT");
                ActionOrientationType actionOrientation = results2.getEnum("ACTION_ORIENTATION", ActionOrientationType.unknown);
                String conditionTimingString = results2.getString("ACTION_TIMING");
                if (conditionTimingString == null) {
                    conditionTimingString = results2.getString("CONDITION_TIMING");
                }
                ConditionTimingType conditionTiming = ConditionTimingType.valueOfFromValue(conditionTimingString);
                MutableTrigger trigger = table2.lookupTrigger(triggerName);
                if (trigger == null) {
                    trigger = new MutableTrigger(table2, triggerName);
                }
                trigger.setEventManipulationType(eventManipulationType);
                trigger.setActionOrder(actionOrder);
                trigger.appendActionCondition(actionCondition);
                trigger.appendActionStatement(actionStatement);
                trigger.setActionOrientation(actionOrientation);
                trigger.setConditionTiming(conditionTiming);
                trigger.addAttributes(results2.getAttributes());
                table2.addTrigger(trigger);
            }
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Could not retrieve trigger information", e2);
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveViewInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasViewsSql()) {
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        String viewInformationSql = informationSchemaViews.getViews();
        Connection connection = this.getDatabaseConnection();
        Statement statement = connection.createStatement();
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(statement.executeQuery(viewInformationSql));
            while (results2.next()) {
                String viewName;
                String schemaName;
                String catalogName = this.quotedName(results2.getString("TABLE_CATALOG"));
                MutableView view = (MutableView)this.lookupTable(catalogName, schemaName = this.quotedName(results2.getString("TABLE_SCHEMA")), viewName = this.quotedName(results2.getString("TABLE_NAME")));
                if (view == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, viewName));
                    continue;
                }
                LOGGER.log(Level.FINER, "Retrieving view information: " + viewName);
                String definition = results2.getString("VIEW_DEFINITION");
                CheckOptionType checkOption = results2.getEnum("CHECK_OPTION", CheckOptionType.unknown);
                boolean updatable = results2.getBoolean("IS_UPDATABLE");
                view.appendDefinition(definition);
                view.setCheckOption(checkOption);
                view.setUpdatable(updatable);
                view.addAttributes(results2.getAttributes());
            }
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Could not retrieve view information", e2);
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
            statement.close();
        }
    }
}

