/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableForeignKey;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.IndexColumnSortSequence;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import sf.util.TemplatingUtility;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TableRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableRetriever.class.getName());

    TableRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createForeignKeys(MetadataResultSet results2, NamedObjectList<MutableForeignKey> foreignKeys) throws SQLException {
        try {
            while (results2.next()) {
                String foreignKeyName = this.quotedName(results2.getString("FK_NAME"));
                if (Utility.isBlank(foreignKeyName)) {
                    foreignKeyName = "<unknown>";
                }
                LOGGER.log(Level.FINER, "Retrieving foreign key: " + foreignKeyName);
                String pkTableCatalogName = this.quotedName(results2.getString("PKTABLE_CAT"));
                String pkTableSchemaName = this.quotedName(results2.getString("PKTABLE_SCHEM"));
                String pkTableName = this.quotedName(results2.getString("PKTABLE_NAME"));
                String pkColumnName = this.quotedName(results2.getString("PKCOLUMN_NAME"));
                String fkTableCatalogName = this.quotedName(results2.getString("FKTABLE_CAT"));
                String fkTableSchemaName = this.quotedName(results2.getString("FKTABLE_SCHEM"));
                String fkTableName = this.quotedName(results2.getString("FKTABLE_NAME"));
                String fkColumnName = this.quotedName(results2.getString("FKCOLUMN_NAME"));
                MutableForeignKey foreignKey = foreignKeys.lookup(foreignKeyName);
                if (foreignKey == null) {
                    foreignKey = new MutableForeignKey(foreignKeyName);
                    foreignKeys.add(foreignKey);
                }
                int keySequence = results2.getInt("KEY_SEQ", 0);
                int updateRule = results2.getInt("UPDATE_RULE", ForeignKeyUpdateRule.unknown.getId());
                int deleteRule = results2.getInt("DELETE_RULE", ForeignKeyUpdateRule.unknown.getId());
                int deferrability = results2.getInt("DEFERRABILITY", ForeignKeyDeferrability.unknown.getId());
                MutableColumn pkColumn = this.lookupOrCreateColumn(pkTableCatalogName, pkTableSchemaName, pkTableName, pkColumnName);
                MutableColumn fkColumn = this.lookupOrCreateColumn(fkTableCatalogName, fkTableSchemaName, fkTableName, fkColumnName);
                if (pkColumn == null || fkColumn == null) continue;
                foreignKey.addColumnPair(keySequence, pkColumn, fkColumn);
                foreignKey.setUpdateRule(ForeignKeyUpdateRule.valueOf(updateRule));
                foreignKey.setDeleteRule(ForeignKeyUpdateRule.valueOf(deleteRule));
                foreignKey.setDeferrability(ForeignKeyDeferrability.valueOf(deferrability));
                foreignKey.addAttributes(results2.getAttributes());
                fkColumn.setReferencedColumn(pkColumn);
                ((MutableTable)pkColumn.getParent()).addForeignKey(foreignKey);
                ((MutableTable)fkColumn.getParent()).addForeignKey(foreignKey);
            }
        }
        finally {
            results2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndices(MutableTable table2, MetadataResultSet results2) throws SQLException {
        try {
            while (results2.next()) {
                String indexName = this.quotedName(results2.getString("INDEX_NAME"));
                if (Utility.isBlank(indexName)) {
                    indexName = "<unknown>";
                }
                LOGGER.log(Level.FINER, String.format("Retrieving index: %s.%s", table2.getFullName(), indexName));
                String columnName2 = this.quotedName(results2.getString("COLUMN_NAME"));
                if (Utility.isBlank(columnName2)) continue;
                MutableIndex index2 = table2.getIndex(indexName);
                if (index2 == null) {
                    index2 = new MutableIndex(table2, indexName);
                    table2.addIndex(index2);
                }
                boolean uniqueIndex = !results2.getBoolean("NON_UNIQUE");
                int type = results2.getInt("TYPE", IndexType.unknown.getId());
                int ordinalPosition = results2.getInt("ORDINAL_POSITION", 0);
                IndexColumnSortSequence sortSequence = IndexColumnSortSequence.valueOfFromCode(results2.getString("ASC_OR_DESC"));
                int cardinality = results2.getInt("CARDINALITY", 0);
                int pages = results2.getInt("PAGES", 0);
                MutableColumn column = table2.getColumn(columnName2);
                if (column == null) continue;
                column.setPartOfUniqueIndex(uniqueIndex);
                MutableIndexColumn indexColumn = new MutableIndexColumn(index2, column);
                indexColumn.setIndexOrdinalPosition(ordinalPosition);
                indexColumn.setSortSequence(sortSequence);
                index2.addColumn(indexColumn);
                index2.setUnique(uniqueIndex);
                index2.setType(IndexType.valueOf(type));
                index2.setCardinality(cardinality);
                index2.setPages(pages);
                index2.addAttributes(results2.getAttributes());
            }
        }
        finally {
            results2.close();
        }
    }

    private MutableColumn lookupOrCreateColumn(MutableTable table2, String columnName2, boolean add5) {
        MutableColumn column = null;
        if (table2 != null) {
            column = table2.getColumn(columnName2);
        }
        if (column == null) {
            column = new MutableColumn(table2, columnName2);
            if (add5) {
                LOGGER.log(Level.FINER, String.format("Adding column to table: %s", column.getFullName()));
                table2.addColumn(column);
            }
        }
        return column;
    }

    private MutableColumn lookupOrCreateColumn(String catalogName, String schemaName, String tableName, String columnName2) {
        MutableColumn column = null;
        MutableSchema schema = this.lookupSchema(catalogName, schemaName);
        if (schema != null) {
            MutableTable table2 = schema.getTable(tableName);
            if (table2 != null) {
                column = table2.getColumn(columnName2);
            } else {
                table2 = new MutableTable(schema, tableName);
            }
            if (column == null) {
                column = new MutableColumn(table2, columnName2);
                LOGGER.log(Level.FINER, String.format("Adding referenced foreign key column to table: %s", column.getFullName()));
                table2.addColumn(column);
            }
        }
        return column;
    }

    void retrieveColumns(MutableTable table2, InclusionRule columnInclusionRule) throws SQLException {
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getColumns(this.unquotedName(table2.getSchema().getCatalogName()), this.unquotedName(table2.getSchema().getSchemaName()), this.unquotedName(table2.getName()), null));
            while (results2.next()) {
                String defaultValue = results2.getString("COLUMN_DEF");
                String columnCatalogName = this.quotedName(results2.getString("TABLE_CAT"));
                String schemaName = this.quotedName(results2.getString("TABLE_SCHEM"));
                String tableName = this.quotedName(results2.getString("TABLE_NAME"));
                String columnName2 = this.quotedName(results2.getString("COLUMN_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving column: %s.%s", tableName, columnName2));
                MutableColumn column = this.lookupOrCreateColumn(table2, columnName2, false);
                String columnFullName = column.getFullName();
                if (!columnInclusionRule.include(columnFullName) || !table2.getName().equals(tableName) || !this.belongsToSchema(table2, columnCatalogName, schemaName)) continue;
                column = this.lookupOrCreateColumn(table2, columnName2, true);
                int ordinalPosition = results2.getInt("ORDINAL_POSITION", 0);
                int dataType = results2.getInt("DATA_TYPE", 0);
                String typeName = results2.getString("TYPE_NAME");
                int size2 = results2.getInt("COLUMN_SIZE", 0);
                int decimalDigits = results2.getInt("DECIMAL_DIGITS", 0);
                boolean isNullable = results2.getInt("NULLABLE", 2) == 1;
                String remarks = results2.getString("REMARKS");
                column.setOrdinalPosition(ordinalPosition);
                column.setType(this.lookupOrCreateColumnDataType((MutableSchema)table2.getSchema(), dataType, typeName));
                column.setSize(size2);
                column.setDecimalDigits(decimalDigits);
                column.setRemarks(remarks);
                column.setNullable(isNullable);
                if (defaultValue != null) {
                    column.setDefaultValue(defaultValue);
                }
                column.addAttributes(results2.getAttributes());
                table2.addColumn(column);
            }
        }
        catch (SQLException e2) {
            SQLException sqlEx = new SQLException("Could not retrieve columns for table " + table2 + ":" + e2.getMessage());
            sqlEx.setNextException(e2);
            throw sqlEx;
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }

    void retrieveForeignKeys(MutableTable table2) throws SQLException {
        NamedObjectList<MutableForeignKey> foreignKeys = new NamedObjectList<MutableForeignKey>();
        DatabaseMetaData metaData = this.getMetaData();
        MetadataResultSet results2 = new MetadataResultSet(metaData.getImportedKeys(this.unquotedName(table2.getSchema().getCatalogName()), this.unquotedName(table2.getSchema().getSchemaName()), this.unquotedName(table2.getName())));
        this.createForeignKeys(results2, foreignKeys);
        results2 = new MetadataResultSet(metaData.getExportedKeys(this.unquotedName(table2.getSchema().getCatalogName()), this.unquotedName(table2.getSchema().getSchemaName()), this.unquotedName(table2.getName())));
        this.createForeignKeys(results2, foreignKeys);
    }

    void retrieveIndices(MutableTable table2, boolean unique2) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        Statement statement = null;
        MetadataResultSet results2 = null;
        try {
            if (informationSchemaViews.hasIndexInfoSql()) {
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("table", table2.getFullName());
                String indexInfoSql = TemplatingUtility.expandTemplate(informationSchemaViews.getIndexInfo(), map3);
                LOGGER.log(Level.FINE, "Using getIndexInfo SQL:\n" + indexInfoSql);
                Connection connection = this.getDatabaseConnection();
                statement = connection.createStatement();
                results2 = new MetadataResultSet(statement.executeQuery(indexInfoSql));
                this.createIndices(table2, results2);
            } else {
                results2 = new MetadataResultSet(this.getMetaData().getIndexInfo(this.unquotedName(table2.getSchema().getCatalogName()), this.unquotedName(table2.getSchema().getSchemaName()), this.unquotedName(table2.getName()), unique2, true));
                this.createIndices(table2, results2);
            }
        }
        catch (SQLException e2) {
            SQLException sqlEx = new SQLException("Could not retrieve indices for table " + table2 + ": " + e2.getMessage());
            sqlEx.setNextException(e2);
            throw sqlEx;
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    void retrievePrimaryKey(MutableTable table2) throws SQLException {
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getPrimaryKeys(this.unquotedName(table2.getSchema().getCatalogName()), this.unquotedName(table2.getSchema().getSchemaName()), this.unquotedName(table2.getName())));
            while (results2.next()) {
                MutableColumn column;
                String columnName2 = this.quotedName(results2.getString("COLUMN_NAME"));
                String primaryKeyName = this.quotedName(results2.getString("PK_NAME"));
                int keySequence = Integer.parseInt(results2.getString("KEY_SEQ"));
                MutablePrimaryKey primaryKey = table2.getPrimaryKey();
                if (primaryKey == null) {
                    primaryKey = new MutablePrimaryKey(table2, primaryKeyName);
                }
                if ((column = table2.getColumn(columnName2)) != null) {
                    column.setPartOfPrimaryKey(true);
                    MutableIndexColumn indexColumn = new MutableIndexColumn(primaryKey, column);
                    indexColumn.setSortSequence(IndexColumnSortSequence.ascending);
                    indexColumn.setIndexOrdinalPosition(keySequence);
                    primaryKey.addColumn(indexColumn);
                }
                table2.setPrimaryKey(primaryKey);
            }
        }
        catch (SQLException e2) {
            SQLException sqlEx = new SQLException("Could not retrieve primary keys for table " + table2 + ": " + e2.getMessage());
            sqlEx.setNextException(e2);
            throw sqlEx;
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTables(String catalogName, String schemaName, String tableNamePattern, TableType[] tableTypes, InclusionRule tableInclusionRule) throws SQLException {
        MetadataResultSet results2 = null;
        try {
            results2 = new MetadataResultSet(this.getMetaData().getTables(this.unquotedName(catalogName), this.unquotedName(schemaName), tableNamePattern, TableType.toStrings(tableTypes)));
            while (results2.next()) {
                String tableName = this.quotedName(results2.getString("TABLE_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving table: %s.%s", schemaName, tableName));
                TableType tableType = results2.getEnum("TABLE_TYPE", TableType.unknown);
                String remarks = results2.getString("REMARKS");
                MutableSchema schema = this.lookupSchema(catalogName, schemaName);
                if (schema == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find schema, %s.%s", catalogName, schemaName));
                    continue;
                }
                MutableTable table2 = tableType == TableType.view ? new MutableView(schema, tableName) : new MutableTable(schema, tableName);
                if (!tableInclusionRule.include(table2.getFullName())) continue;
                table2.setType(tableType);
                table2.setRemarks(remarks);
                schema.addTable(table2);
            }
        }
        finally {
            if (results2 != null) {
                results2.close();
            }
        }
    }
}

