/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Options;
import sf.util.ObjectToString;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Config
extends HashMap<String, String>
implements Options {
    private static final long serialVersionUID = 8720699738076915453L;
    private static final Logger LOGGER = Logger.getLogger(Config.class.getName());

    public static Config load(InputStream configStream) {
        Properties configProperties = new Properties();
        if (configStream != null) {
            configProperties = Config.loadProperties(configProperties, configStream);
        }
        return new Config(configProperties);
    }

    public static Config load(String ... configFilenames) {
        Properties configProperties = new Properties();
        if (configFilenames != null) {
            for (String configFilename : configFilenames) {
                if (Utility.isBlank(configFilename)) continue;
                configProperties = Config.loadProperties(configProperties, new File(configFilename));
            }
        }
        return new Config(configProperties);
    }

    private static Properties loadProperties(Properties properties2, File propertiesFile) {
        try {
            BufferedInputStream propertiesStream = new BufferedInputStream(new FileInputStream(propertiesFile));
            Config.loadProperties(properties2, propertiesStream);
        }
        catch (FileNotFoundException e2) {
            LOGGER.log(Level.WARNING, "Cannot load properties from file, " + propertiesFile.getAbsolutePath());
            LOGGER.log(Level.FINEST, e2.getMessage(), e2);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(Properties properties2, InputStream propertiesStream) {
        try {
            properties2.load(propertiesStream);
            propertiesStream.close();
        }
        catch (IOException e2) {
            LOGGER.log(Level.WARNING, "Error loading properties", e2);
        }
        finally {
            try {
                if (propertiesStream != null) {
                    propertiesStream.close();
                }
            }
            catch (IOException e3) {
                LOGGER.log(Level.WARNING, "Error closing stream", e3);
            }
        }
        return properties2;
    }

    private static Map<String, String> propertiesMap(Properties properties2) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties2 != null) {
            Set<Map.Entry<Object, Object>> entries = properties2.entrySet();
            for (Map.Entry<Object, Object> entry2 : entries) {
                propertiesMap.put((String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        return propertiesMap;
    }

    public Config() {
    }

    public Config(Map<String, String> config) {
        if (config != null) {
            this.putAll(config);
        }
    }

    public Config(Properties properties2) {
        super(Config.propertiesMap(properties2));
    }

    public boolean getBooleanValue(String propertyName) {
        return Boolean.parseBoolean(this.getStringValue(propertyName, "false"));
    }

    public int getIntegerValue(String propertyName) {
        return Integer.parseInt(this.getStringValue(propertyName, null));
    }

    public String getStringValue(String propertyName, String defaultValue) {
        String value2 = (String)this.get(propertyName);
        if (value2 == null) {
            value2 = defaultValue;
        }
        return value2;
    }

    @Override
    public String toString() {
        return ObjectToString.toString(this);
    }
}

