/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.BaseDatabaseConnectionOptions;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import sf.util.TemplatingUtility;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseConfigConnectionOptions
extends BaseDatabaseConnectionOptions {
    private static final long serialVersionUID = -8141436553988174836L;
    private static final String DRIVER = "driver";
    private static final String URL = "url";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String DATABASE = "database";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private final Map<String, String> properties;

    public DatabaseConfigConnectionOptions(Map<String, String> properties2) throws SchemaCrawlerException {
        if (properties2 == null) {
            throw new SchemaCrawlerException("No connection properties provided");
        }
        this.properties = new HashMap<String, String>(properties2);
        DatabaseConfigConnectionOptions.loadJdbcDriver(properties2.get(DRIVER));
        this.setUser(properties2.get(USER));
        this.setPassword(properties2.get(PASSWORD));
    }

    public DatabaseConfigConnectionOptions(String configResource) throws SchemaCrawlerException {
        this(Config.load(DatabaseConfigConnectionOptions.class.getResourceAsStream(configResource)));
    }

    @Override
    public String getConnectionUrl() {
        HashMap<String, String> properties2 = new HashMap<String, String>(this.properties);
        TemplatingUtility.substituteVariables(properties2);
        String connectionUrl = (String)properties2.get(URL);
        if (!TemplatingUtility.extractTemplateVariables(connectionUrl).isEmpty()) {
            throw new IllegalArgumentException("Insufficient parameters for database connection URL");
        }
        return connectionUrl;
    }

    public String getDatabase() {
        return this.properties.get(DATABASE);
    }

    public String getHost() {
        return this.properties.get(HOST);
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.properties.get(PORT));
        }
        catch (NumberFormatException e2) {
            return 0;
        }
    }

    public void setDatabase(String database) {
        if (!Utility.isBlank(database)) {
            this.properties.put(DATABASE, database);
        }
    }

    public void setHost(String host) {
        if (!Utility.isBlank(host)) {
            this.properties.put(HOST, host);
        }
    }

    public void setPort(int port) {
        if (port > 0) {
            this.properties.put(PORT, String.valueOf(port));
        }
    }
}

