/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schema.TableType;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoLevel;

public final class SchemaCrawlerOptions
implements Options {
    public static final String DEFAULT_TABLE_TYPES = "TABLE,VIEW";
    private static final long serialVersionUID = -3557794862382066029L;
    private static final String SC_SCHEMA_PATTERN_EXCLUDE = "schemacrawler.schema.pattern.exclude";
    private static final String SC_SCHEMA_PATTERN_INCLUDE = "schemacrawler.schema.pattern.include";
    private static final String SC_TABLE_TYPES = "schemacrawler.table_types";
    private static final String SC_SHOW_STORED_PROCEDURES = "schemacrawler.show_stored_procedures";
    private static final String SC_COLUMN_PATTERN_EXCLUDE = "schemacrawler.column.pattern.exclude";
    private static final String SC_COLUMN_PATTERN_INCLUDE = "schemacrawler.column.pattern.include";
    private static final String SC_TABLE_PATTERN_EXCLUDE = "schemacrawler.table.pattern.exclude";
    private static final String SC_TABLE_PATTERN_INCLUDE = "schemacrawler.table.pattern.include";
    private static final String SC_PROCEDURE_COLUMN_PATTERN_EXCLUDE = "schemacrawler.procedure.inout.pattern.exclude";
    private static final String SC_PROCEDURE_COLUMN_PATTERN_INCLUDE = "schemacrawler.procedure.inout.pattern.include";
    private static final String SC_PROCEDURE_PATTERN_EXCLUDE = "schemacrawler.procedure.pattern.exclude";
    private static final String SC_PROCEDURE_PATTERN_INCLUDE = "schemacrawler.procedure.pattern.include";
    private static final String SC_GREP_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.column.pattern.exclude";
    private static final String SC_GREP_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.column.pattern.include";
    private static final String SC_GREP_PROCEDURE_COLUMN_PATTERN_EXCLUDE = "schemacrawler.grep.procedure.inout.pattern.exclude";
    private static final String SC_GREP_PROCEDURE_COLUMN_PATTERN_INCLUDE = "schemacrawler.grep.procedure.inout.pattern.include";
    private static final String SC_GREP_INVERT_MATCH = "schemacrawler.grep.invert-match";
    private static final String SC_SORT_ALPHABETICALLY_TABLES = "schemacrawler.sort_alphabetically.tables";
    private static final String SC_SORT_ALPHABETICALLY_PROCEDURE_COLUMNS = "schemacrawler.sort_alphabetically.procedure_columns";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_INDEXES = "schemacrawler.sort_alphabetically.table_indices";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS = "schemacrawler.sort_alphabetically.table_foreignkeys";
    private static final String SC_SORT_ALPHABETICALLY_TABLE_COLUMNS = "schemacrawler.sort_alphabetically.table_columns";
    private InclusionRule schemaInclusionRule;
    private TableType[] tableTypes;
    private boolean showStoredProcedures;
    private String tableNamePattern;
    private InclusionRule tableInclusionRule;
    private InclusionRule columnInclusionRule;
    private InclusionRule procedureInclusionRule;
    private InclusionRule procedureColumnInclusionRule;
    private InclusionRule grepColumnInclusionRule;
    private InclusionRule grepProcedureColumnInclusionRule;
    private boolean grepInvertMatch;
    private boolean isAlphabeticalSortForTables;
    private boolean isAlphabeticalSortForTableColumns;
    private boolean isAlphabeticalSortForForeignKeys;
    private boolean isAlphabeticalSortForIndexes;
    private boolean isAlphabeticalSortForProcedureColumns;
    private SchemaInfoLevel schemaInfoLevel;
    private InformationSchemaViews informationSchemaViews;

    private static TableType[] copyTableTypes(TableType[] tableTypes) {
        TableType[] tableTypesCopy = new TableType[tableTypes.length];
        System.arraycopy(tableTypes, 0, tableTypesCopy, 0, tableTypes.length);
        return tableTypesCopy;
    }

    public SchemaCrawlerOptions() {
        this(new Config());
    }

    public SchemaCrawlerOptions(Config config) {
        Config configProperties = config == null ? new Config() : config;
        String tableTypesString = configProperties.getStringValue(SC_TABLE_TYPES, DEFAULT_TABLE_TYPES);
        this.tableTypes = TableType.valueOf(tableTypesString.split(","));
        this.showStoredProcedures = configProperties.getBooleanValue(SC_SHOW_STORED_PROCEDURES);
        this.informationSchemaViews = new InformationSchemaViews(config);
        this.schemaInclusionRule = new InclusionRule(configProperties.getStringValue(SC_SCHEMA_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_SCHEMA_PATTERN_EXCLUDE, ""));
        this.tableInclusionRule = new InclusionRule(configProperties.getStringValue(SC_TABLE_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_TABLE_PATTERN_EXCLUDE, ""));
        this.columnInclusionRule = new InclusionRule(configProperties.getStringValue(SC_COLUMN_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_COLUMN_PATTERN_EXCLUDE, ""));
        this.procedureInclusionRule = new InclusionRule(configProperties.getStringValue(SC_PROCEDURE_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_PROCEDURE_PATTERN_EXCLUDE, ""));
        this.procedureColumnInclusionRule = new InclusionRule(configProperties.getStringValue(SC_PROCEDURE_COLUMN_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_PROCEDURE_COLUMN_PATTERN_EXCLUDE, ""));
        this.grepColumnInclusionRule = new InclusionRule(configProperties.getStringValue(SC_GREP_COLUMN_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_GREP_COLUMN_PATTERN_EXCLUDE, ""));
        this.grepProcedureColumnInclusionRule = new InclusionRule(configProperties.getStringValue(SC_GREP_PROCEDURE_COLUMN_PATTERN_INCLUDE, ".*"), configProperties.getStringValue(SC_GREP_PROCEDURE_COLUMN_PATTERN_EXCLUDE, ""));
        this.grepInvertMatch = configProperties.getBooleanValue(SC_GREP_INVERT_MATCH);
        this.isAlphabeticalSortForTables = Boolean.parseBoolean(configProperties.getStringValue(SC_SORT_ALPHABETICALLY_TABLES, "true"));
        this.isAlphabeticalSortForTableColumns = configProperties.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_COLUMNS);
        this.isAlphabeticalSortForForeignKeys = configProperties.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_FOREIGNKEYS);
        this.isAlphabeticalSortForIndexes = configProperties.getBooleanValue(SC_SORT_ALPHABETICALLY_TABLE_INDEXES);
        this.isAlphabeticalSortForProcedureColumns = configProperties.getBooleanValue(SC_SORT_ALPHABETICALLY_PROCEDURE_COLUMNS);
    }

    public InclusionRule getColumnInclusionRule() {
        return this.columnInclusionRule;
    }

    public InclusionRule getGrepColumnInclusionRule() {
        return this.grepColumnInclusionRule;
    }

    public InclusionRule getGrepProcedureColumnInclusionRule() {
        return this.grepProcedureColumnInclusionRule;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViews;
    }

    public InclusionRule getProcedureColumnInclusionRule() {
        return this.procedureColumnInclusionRule;
    }

    public InclusionRule getProcedureInclusionRule() {
        return this.procedureInclusionRule;
    }

    public InclusionRule getSchemaInclusionRule() {
        return this.schemaInclusionRule;
    }

    public SchemaInfoLevel getSchemaInfoLevel() {
        if (this.schemaInfoLevel == null) {
            return SchemaInfoLevel.standard();
        }
        return this.schemaInfoLevel;
    }

    public InclusionRule getTableInclusionRule() {
        return this.tableInclusionRule;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public TableType[] getTableTypes() {
        TableType[] tableTypesCopy = SchemaCrawlerOptions.copyTableTypes(this.tableTypes);
        return tableTypesCopy;
    }

    public boolean isAlphabeticalSortForForeignKeys() {
        return this.isAlphabeticalSortForForeignKeys;
    }

    public boolean isAlphabeticalSortForIndexes() {
        return this.isAlphabeticalSortForIndexes;
    }

    public boolean isAlphabeticalSortForProcedureColumns() {
        return this.isAlphabeticalSortForProcedureColumns;
    }

    public boolean isAlphabeticalSortForTableColumns() {
        return this.isAlphabeticalSortForTableColumns;
    }

    public boolean isAlphabeticalSortForTables() {
        return this.isAlphabeticalSortForTables;
    }

    public boolean isGrepInvertMatch() {
        return this.grepInvertMatch;
    }

    public boolean isShowStoredProcedures() {
        return this.showStoredProcedures;
    }

    public void setAlphabeticalSortForForeignKeys(boolean alphabeticalSort) {
        this.isAlphabeticalSortForForeignKeys = alphabeticalSort;
    }

    public void setAlphabeticalSortForIndexes(boolean alphabeticalSort) {
        this.isAlphabeticalSortForIndexes = alphabeticalSort;
    }

    public void setAlphabeticalSortForProcedureColumns(boolean alphabeticalSort) {
        this.isAlphabeticalSortForProcedureColumns = alphabeticalSort;
    }

    public void setAlphabeticalSortForTableColumns(boolean alphabeticalSort) {
        this.isAlphabeticalSortForTableColumns = alphabeticalSort;
    }

    public void setAlphabeticalSortForTables(boolean alphabeticalSort) {
        this.isAlphabeticalSortForTables = alphabeticalSort;
    }

    public void setColumnInclusionRule(InclusionRule columnInclusionRule) {
        if (columnInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.columnInclusionRule = columnInclusionRule;
    }

    public void setGrepColumnInclusionRule(InclusionRule grepColumnInclusionRule) {
        if (grepColumnInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.grepColumnInclusionRule = grepColumnInclusionRule;
    }

    public void setGrepInvertMatch(boolean grepInvertMatch) {
        this.grepInvertMatch = grepInvertMatch;
    }

    public void setGrepProcedureColumnInclusionRule(InclusionRule grepProcedureColumnInclusionRule) {
        if (grepProcedureColumnInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.grepProcedureColumnInclusionRule = grepProcedureColumnInclusionRule;
    }

    public void setInformationSchemaViews(InformationSchemaViews informationSchemaViews) {
        this.informationSchemaViews = informationSchemaViews == null ? new InformationSchemaViews() : informationSchemaViews;
    }

    public void setProcedureColumnInclusionRule(InclusionRule procedureColumnInclusionRule) {
        if (procedureColumnInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.procedureColumnInclusionRule = procedureColumnInclusionRule;
    }

    public void setProcedureInclusionRule(InclusionRule procedureInclusionRule) {
        if (procedureInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.procedureInclusionRule = procedureInclusionRule;
    }

    public void setSchemaInclusionRule(InclusionRule schemaInclusionRule) {
        if (schemaInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.schemaInclusionRule = schemaInclusionRule;
    }

    public void setSchemaInfoLevel(SchemaInfoLevel schemaInfoLevel) {
        this.schemaInfoLevel = schemaInfoLevel;
    }

    public void setShowStoredProcedures(boolean showStoredProcedures) {
        this.showStoredProcedures = showStoredProcedures;
    }

    public void setTableInclusionRule(InclusionRule tableInclusionRule) {
        if (tableInclusionRule == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.tableInclusionRule = tableInclusionRule;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTableTypes(String tableTypesString) {
        if (tableTypesString == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.tableTypes = TableType.valueOf(tableTypesString.split(","));
    }

    public void setTableTypes(TableType[] tableTypesArray) {
        if (tableTypesArray == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.tableTypes = SchemaCrawlerOptions.copyTableTypes(tableTypesArray);
    }

    public void setTableTypesString(String tableTypesString) {
        this.setTableTypes(tableTypesString);
    }
}

