/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.BaseLinter;
import schemacrawler.tools.analysis.Lint;
import sf.util.ObjectToString;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinterTableWithIncrementingColumns
extends BaseLinter<Table> {
    @Override
    public void lint(Table table2) {
        HashMap<String, List<Column>> incrementingColumns;
        if (table2 != null && !(incrementingColumns = this.findIncrementingColumns(table2.getColumns())).isEmpty()) {
            this.addLint(table2, new Lint("incrementing columns", incrementingColumns){
                private static final long serialVersionUID = -9152369844685463520L;

                public String getLintValueAsString() {
                    StringBuilder buffer = new StringBuilder();
                    for (List incrementingColumnsGroup : incrementingColumns.values()) {
                        ArrayList<String> columnNames = new ArrayList<String>();
                        for (Column column : incrementingColumnsGroup) {
                            columnNames.add(column.getName());
                        }
                        buffer.append(ObjectToString.toString(columnNames)).append(Utility.NEWLINE);
                    }
                    return buffer.toString();
                }
            });
        }
    }

    private HashMap<String, List<Column>> findIncrementingColumns(Column[] columns2) {
        if (columns2 == null || columns2.length <= 1) {
            return new HashMap<String, List<Column>>();
        }
        Pattern pattern = Pattern.compile("([^0-9]*)([0-9]+)");
        HashMap<String, Integer> incrementingColumnsMap = new HashMap<String, Integer>();
        for (Column column : columns2) {
            String columnName2 = Utility.convertForComparison(column.getName());
            incrementingColumnsMap.put(columnName2, 1);
            Matcher matcher2 = pattern.matcher(columnName2);
            if (!matcher2.matches()) continue;
            String columnNameBase = matcher2.group(1);
            if (incrementingColumnsMap.containsKey(columnNameBase)) {
                incrementingColumnsMap.put(columnNameBase, (Integer)incrementingColumnsMap.get(columnNameBase) + 1);
                continue;
            }
            incrementingColumnsMap.put(columnNameBase, 1);
        }
        HashSet columnNameBases = new HashSet(incrementingColumnsMap.keySet());
        for (String columnNameBase : columnNameBases) {
            if ((Integer)incrementingColumnsMap.get(columnNameBase) != 1) continue;
            incrementingColumnsMap.remove(columnNameBase);
        }
        HashMap<String, List<Column>> incrementingColumns = new HashMap<String, List<Column>>();
        for (String columnNameBase : incrementingColumnsMap.keySet()) {
            incrementingColumns.put(columnNameBase, new ArrayList());
        }
        for (Column column : columns2) {
            String columnNameBase;
            Matcher matcher3;
            String columnName3 = Utility.convertForComparison(column.getName());
            if (incrementingColumnsMap.containsKey(columnName3)) {
                incrementingColumns.get(columnName3).add(column);
            }
            if (!(matcher3 = pattern.matcher(columnName3)).matches() || !incrementingColumnsMap.containsKey(columnNameBase = matcher3.group(1))) continue;
            incrementingColumns.get(columnNameBase).add(column);
        }
        return incrementingColumns;
    }
}

