/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.BaseLinter;
import schemacrawler.tools.analysis.Lint;
import sf.util.ObjectToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinterTableWithQuotedNames
extends BaseLinter<Table> {
    @Override
    public void lint(Table table2) {
        if (table2 != null) {
            List<String> spacesInNamesList = this.findColumnsWithQuotedNames(table2.getColumns());
            String tableName = table2.getName();
            if (this.isQuotedName(tableName)) {
                spacesInNamesList.add(0, tableName);
            }
            if (!spacesInNamesList.isEmpty()) {
                final String[] spacesInNames = spacesInNamesList.toArray(new String[spacesInNamesList.size()]);
                this.addLint(table2, new Lint("spaces in names, or reserved words", (Serializable)spacesInNames){
                    private static final long serialVersionUID = 4306137113072609086L;

                    public String getLintValueAsString() {
                        return ObjectToString.toString(spacesInNames);
                    }
                });
            }
        }
    }

    private List<String> findColumnsWithQuotedNames(Column[] columns2) {
        ArrayList<String> columnsWithQuotedNames = new ArrayList<String>();
        for (Column column : columns2) {
            String columnName2 = column.getName();
            if (!this.isQuotedName(columnName2)) continue;
            columnsWithQuotedNames.add(columnName2);
        }
        return columnsWithQuotedNames;
    }

    private boolean isQuotedName(String name) {
        int nameLength = name.length();
        char[] namechars = new char[nameLength];
        name.getChars(0, nameLength, namechars, 0);
        return !Character.isJavaIdentifierStart(namechars[0]) && namechars[0] == namechars[nameLength - 1];
    }
}

