/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.BundledDriverConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandLineConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.ConfigConnectionOptionsParser;
import schemacrawler.tools.commandline.ConfigParser;
import schemacrawler.tools.commandline.OutputOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerOptionsParser;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.Utility;

public final class SchemaCrawlerCommandLine
implements CommandLine {
    private static final long serialVersionUID = -3748989545708155963L;
    private final String command;
    private final Config config;
    private final SchemaCrawlerOptions schemaCrawlerOptions;
    private final OutputOptions outputOptions;
    private final ConnectionOptions connectionOptions;

    public SchemaCrawlerCommandLine(ConnectionOptions connectionOptions, String ... args2) throws SchemaCrawlerException {
        this(null, connectionOptions, args2);
    }

    public SchemaCrawlerCommandLine(String configResource, String ... args2) throws SchemaCrawlerException {
        this(configResource, (ConnectionOptions)null, args2);
    }

    private SchemaCrawlerCommandLine(String configResource, ConnectionOptions connectionOptions, String ... args2) throws SchemaCrawlerException {
        if (args2 == null) {
            throw new IllegalArgumentException("No command line arguments provided");
        }
        if (args2.length > 0) {
            this.command = new CommandParser(args2).getOptions().toString();
            this.outputOptions = new OutputOptionsParser(args2).getOptions();
        } else {
            this.command = null;
            this.outputOptions = new OutputOptions();
        }
        if (!Utility.isBlank(configResource)) {
            this.config = Config.load(SchemaCrawlerCommandLine.class.getResourceAsStream(configResource));
            this.connectionOptions = new BundledDriverConnectionOptionsParser(args2, this.config).getOptions();
        } else {
            this.config = args2 != null && args2.length > 0 ? new ConfigParser(args2).getOptions() : new Config();
            if (connectionOptions != null) {
                this.connectionOptions = connectionOptions;
            } else {
                ConnectionOptions parsedConnectionOptions = new CommandLineConnectionOptionsParser(args2, this.config).getOptions();
                if (parsedConnectionOptions == null) {
                    parsedConnectionOptions = new ConfigConnectionOptionsParser(args2, this.config).getOptions();
                }
                this.connectionOptions = parsedConnectionOptions;
            }
        }
        this.schemaCrawlerOptions = new SchemaCrawlerOptionsParser(args2, this.config).getOptions();
    }

    public void execute() throws Exception {
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        if (this.outputOptions != null) {
            executable.setOutputOptions(this.outputOptions);
        }
        if (this.schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        }
        if (this.config != null) {
            executable.setAdditionalConfiguration(this.config);
        }
        if (this.connectionOptions == null) {
            throw new SchemaCrawlerException("No connection options provided");
        }
        executable.execute(this.connectionOptions.createConnection());
    }

    public final String getCommand() {
        return this.command;
    }

    public final Config getConfig() {
        return this.config;
    }

    public final ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }
}

