/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.options.HelpOptions;
import sf.util.Utility;

public final class SchemaCrawlerHelpCommandLine
implements CommandLine {
    private static final long serialVersionUID = -3748989545708155963L;
    private final boolean hideConfig;
    private final String command;
    private final HelpOptions helpOptions;

    private static void showHelp(String helpResource) {
        String helpResourceName = Utility.isBlank(helpResource) || SchemaCrawlerHelpCommandLine.class.getResource(helpResource) == null ? "/help/DefaultExecutable.txt" : helpResource;
        String helpText = Utility.readResourceFully(helpResourceName);
        System.out.println(helpText);
    }

    public SchemaCrawlerHelpCommandLine(String[] args2, HelpOptions helpOptions, String configResource) throws SchemaCrawlerException {
        if (args2 == null) {
            throw new IllegalArgumentException("No command line arguments provided");
        }
        if (helpOptions == null) {
            throw new SchemaCrawlerException("No help options provided");
        }
        this.helpOptions = helpOptions;
        this.hideConfig = !Utility.isBlank(configResource);
        this.command = args2.length == 0 ? null : new CommandParser(args2).getOptions().toString();
    }

    public void execute() throws SchemaCrawlerException {
        System.out.println(this.helpOptions.getTitle());
        SchemaCrawlerHelpCommandLine.showHelp("/help/SchemaCrawler.txt");
        System.out.println();
        SchemaCrawlerHelpCommandLine.showHelp(this.helpOptions.getResourceConnections());
        SchemaCrawlerHelpCommandLine.showHelp("/help/SchemaCrawlerOptions.txt");
        if (!this.hideConfig) {
            SchemaCrawlerHelpCommandLine.showHelp("/help/Config.txt");
        }
        SchemaCrawlerHelpCommandLine.showHelp("/help/ApplicationOptions.txt");
        CommandRegistry commandRegistry = new CommandRegistry();
        if (this.command == null) {
            String[] availableCommands;
            SchemaCrawlerHelpCommandLine.showHelp("/help/Command.txt");
            System.out.println("  Available commands are: ");
            for (String availableCommand : availableCommands = commandRegistry.lookupAvailableCommands()) {
                System.out.println("  " + availableCommand);
            }
        } else {
            String commandExecutableClassName = commandRegistry.lookupCommandExecutableClassName(this.command);
            String helpResource = "/help/" + commandExecutableClassName.substring(commandExecutableClassName.lastIndexOf(46) + 1) + ".txt";
            SchemaCrawlerHelpCommandLine.showHelp(helpResource);
        }
        System.exit(0);
    }

    public final String getCommand() {
        return this.command;
    }
}

