/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.commandline.ApplicationOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerHelpCommandLine;
import schemacrawler.tools.options.ApplicationOptions;
import schemacrawler.tools.options.HelpOptions;

public class SchemaCrawlerMain {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerMain.class.getName());

    public static void main(String[] args2) throws Exception {
        SchemaCrawlerMain.main(args2, new HelpOptions(""), null);
    }

    public static void main(String[] args2, HelpOptions helpOptions, String configResource) throws Exception {
        boolean showHelp;
        ApplicationOptions applicationOptions;
        if (args2.length == 0) {
            applicationOptions = new ApplicationOptions();
            showHelp = true;
        } else {
            applicationOptions = new ApplicationOptionsParser(args2).getOptions();
            showHelp = applicationOptions.isShowHelp();
        }
        applicationOptions.applyApplicationLogLevel();
        LOGGER.log(Level.CONFIG, "Command line: " + Arrays.toString(args2));
        CommandLine commandLine2 = showHelp ? new SchemaCrawlerHelpCommandLine(args2, helpOptions, configResource) : new SchemaCrawlerCommandLine(configResource, args2);
        commandLine2.execute();
    }

    private SchemaCrawlerMain() {
    }
}

