/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.commandline.InfoLevel;
import sf.util.CommandLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SchemaCrawlerOptionsParser
extends BaseOptionsParser<SchemaCrawlerOptions> {
    private final CommandLineParser.StringOption optionInfoLevel = new CommandLineParser.StringOption('\u0000', "infolevel", "standard");
    private final CommandLineParser.StringOption optionSchemas = new CommandLineParser.StringOption('\u0000', "schemas", "");
    private final CommandLineParser.BooleanOption optionShowStoredProcedures = new CommandLineParser.BooleanOption('\u0000', "show_stored_procedures");
    private final CommandLineParser.StringOption optionTableTypes = new CommandLineParser.StringOption('\u0000', "table_types", "TABLE,VIEW");
    private final CommandLineParser.StringOption optionTables = new CommandLineParser.StringOption('\u0000', "tables", ".*");
    private final CommandLineParser.StringOption optionExcludeColumns = new CommandLineParser.StringOption('\u0000', "excludecolumns", "");
    private final CommandLineParser.StringOption optionProcedures = new CommandLineParser.StringOption('\u0000', "procedures", ".*");
    private final CommandLineParser.StringOption optionExcludeProcedureColumns = new CommandLineParser.StringOption('\u0000', "excludeinout", "");
    private final CommandLineParser.StringOption optionGrepColumns = new CommandLineParser.StringOption('\u0000', "grepcolumns", "");
    private final CommandLineParser.StringOption optionGrepProcedureColumns = new CommandLineParser.StringOption('\u0000', "grepinout", "");
    private final CommandLineParser.BooleanOption optionGrepInvertMatch = new CommandLineParser.BooleanOption('v', "invert-match");
    private final CommandLineParser.BooleanOption optionSortTables = new CommandLineParser.BooleanOption('\u0000', "sorttables");
    private final CommandLineParser.BooleanOption optionSortColumns = new CommandLineParser.BooleanOption('\u0000', "sortcolumns");
    private final CommandLineParser.BooleanOption optionSortInout = new CommandLineParser.BooleanOption('\u0000', "sortinout");
    private final SchemaCrawlerOptions options;

    SchemaCrawlerOptionsParser(String[] args2, Config config) {
        super(args2);
        this.options = new SchemaCrawlerOptions(config);
    }

    @Override
    protected SchemaCrawlerOptions getOptions() {
        this.parse(new CommandLineParser.Option[]{this.optionInfoLevel, this.optionSchemas, this.optionTableTypes, this.optionShowStoredProcedures, this.optionTables, this.optionExcludeColumns, this.optionProcedures, this.optionExcludeProcedureColumns, this.optionGrepColumns, this.optionGrepProcedureColumns, this.optionGrepInvertMatch, this.optionSortTables, this.optionSortColumns, this.optionSortInout});
        if (this.optionInfoLevel.isFound()) {
            try {
                String infoLevel = (String)this.optionInfoLevel.getValue();
                SchemaInfoLevel schemaInfoLevel = InfoLevel.valueOf(infoLevel).getSchemaInfoLevel();
                this.options.setSchemaInfoLevel(schemaInfoLevel);
            }
            catch (IllegalArgumentException e2) {
                this.options.setSchemaInfoLevel(SchemaInfoLevel.standard());
            }
        }
        if (this.optionSchemas.isFound()) {
            InclusionRule schemaInclusionRule = new InclusionRule((String)this.optionSchemas.getValue(), "");
            this.options.setSchemaInclusionRule(schemaInclusionRule);
        }
        if (this.optionTableTypes.isFound()) {
            this.options.setTableTypes((String)this.optionTableTypes.getValue());
        }
        if (this.optionShowStoredProcedures.isFound()) {
            this.options.setShowStoredProcedures((Boolean)this.optionShowStoredProcedures.getValue());
        }
        if (this.optionTables.isFound()) {
            InclusionRule tableInclusionRule = new InclusionRule((String)this.optionTables.getValue(), "");
            this.options.setTableInclusionRule(tableInclusionRule);
        }
        if (this.optionExcludeColumns.isFound()) {
            InclusionRule columnInclusionRule = new InclusionRule(".*", (String)this.optionExcludeColumns.getValue());
            this.options.setColumnInclusionRule(columnInclusionRule);
        }
        if (this.optionProcedures.isFound()) {
            InclusionRule procedureInclusionRule = new InclusionRule((String)this.optionProcedures.getValue(), "");
            this.options.setProcedureInclusionRule(procedureInclusionRule);
        }
        if (this.optionExcludeProcedureColumns.isFound()) {
            InclusionRule procedureColumnInclusionRule = new InclusionRule(".*", (String)this.optionExcludeProcedureColumns.getValue());
            this.options.setProcedureColumnInclusionRule(procedureColumnInclusionRule);
        }
        if (this.optionGrepInvertMatch.isFound()) {
            this.options.setGrepInvertMatch((Boolean)this.optionGrepInvertMatch.getValue());
        }
        if (this.optionGrepColumns.isFound()) {
            InclusionRule grepColumnInclusionRule = new InclusionRule((String)this.optionGrepColumns.getValue(), "");
            this.options.setGrepColumnInclusionRule(grepColumnInclusionRule);
        }
        if (this.optionGrepProcedureColumns.isFound()) {
            InclusionRule grepProcedureColumnInclusionRule = new InclusionRule((String)this.optionGrepProcedureColumns.getValue(), "");
            this.options.setGrepProcedureColumnInclusionRule(grepProcedureColumnInclusionRule);
        }
        if (this.optionSortColumns.isFound()) {
            this.options.setAlphabeticalSortForTableColumns((Boolean)this.optionSortColumns.getValue());
        }
        if (this.optionSortTables.isFound()) {
            this.options.setAlphabeticalSortForTables((Boolean)this.optionSortTables.getValue());
        }
        if (this.optionSortInout.isFound()) {
            this.options.setAlphabeticalSortForProcedureColumns((Boolean)this.optionSortInout.getValue());
        }
        return this.options;
    }
}

