/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputOptions;

public class SchemaCrawlerExecutable
extends BaseExecutable {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerExecutable.class.getName());

    public SchemaCrawlerExecutable(String commands) {
        super(commands);
    }

    protected void executeOn(Database database, Connection connection) throws Exception {
        CommandRegistry commandRegistry = new CommandRegistry();
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        ArrayList<Executable> executables2 = new ArrayList<Executable>();
        for (String command2 : commands) {
            Executable executable;
            String commandExecutableClassName = commandRegistry.lookupCommandExecutableClassName(command2);
            Class<?> commandExecutableClass = Class.forName(commandExecutableClassName);
            try {
                executable = (Executable)commandExecutableClass.newInstance();
            }
            catch (Exception e2) {
                LOGGER.log(Level.FINE, "Could not instantiate " + commandExecutableClassName + " using the default constructor", e2);
                Constructor<?> constructor = commandExecutableClass.getConstructor(String.class);
                executable = (Executable)constructor.newInstance(command2);
            }
            executables2.add(executable);
        }
        for (Executable executable : executables2) {
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
            executable.setAdditionalConfiguration(this.additionalConfiguration);
            String command3 = executable.getCommand();
            OutputOptions executableOutputOptions = this.outputOptions.duplicate();
            if (commands.size() > 1) {
                if (commands.isFirstCommand(command3)) {
                    executableOutputOptions.setNoFooter(true);
                } else if (commands.isLastCommand(command3)) {
                    executableOutputOptions.setNoHeader(true);
                    executableOutputOptions.setNoInfo(true);
                    executableOutputOptions.setAppendOutput(true);
                } else {
                    executableOutputOptions.setNoHeader(true);
                    executableOutputOptions.setNoInfo(true);
                    executableOutputOptions.setNoFooter(true);
                    executableOutputOptions.setAppendOutput(true);
                }
            }
            executable.setOutputOptions(executableOutputOptions);
            ((BaseExecutable)executable).executeOn(database, connection);
        }
    }
}

