/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.Utility;

final class GraphGenerator {
    private static final Logger LOGGER = Logger.getLogger(GraphGenerator.class.getName());
    private final File dotFile;
    private final String graphOutputFormat;
    private final File diagramFile;

    GraphGenerator(File dotFile, String outputFormat, File diagramOutputFile) throws IOException {
        if (dotFile == null || dotFile.isDirectory() || !dotFile.exists() || !dotFile.canRead()) {
            throw new IOException("Cannot read the input DOT file, " + dotFile);
        }
        this.dotFile = dotFile;
        this.graphOutputFormat = this.determineGraphOutputFormat(outputFormat);
        this.diagramFile = this.determineDiagramFile(diagramOutputFile);
    }

    private File determineDiagramFile(File diagramOutputFile) {
        File diagramFile = diagramOutputFile == null ? new File(".", "schemacrawler." + UUID.randomUUID() + "." + this.graphOutputFormat) : diagramOutputFile;
        return diagramFile;
    }

    private String determineGraphOutputFormat(String outputFormat) {
        String graphOutputFormat = outputFormat;
        List<String> outputFormats = Arrays.asList("canon", "cmap", "cmapx", "cmapx_np", "dot", "eps", "fig", "gd", "gd2", "gif", "gv", "imap", "imap_np", "ismap", "jpe", "jpeg", "jpg", "pdf", "plain", "plain-ext", "png", "ps", "ps2", "svg", "svgz", "tk", "vml", "vmlz", "vrml", "wbmp", "xdot");
        if (Utility.isBlank(graphOutputFormat) || !outputFormats.contains(graphOutputFormat)) {
            graphOutputFormat = "png";
        }
        return graphOutputFormat;
    }

    void generateDiagram() throws IOException {
        String graphGenerator = System.getProperty("schemacrawler.graph_generator", "dot");
        Object[] command2 = new String[]{graphGenerator, "-q", "-T" + this.graphOutputFormat, "-o", this.diagramFile.getAbsolutePath(), this.dotFile.getAbsolutePath()};
        LOGGER.log(Level.CONFIG, "Executing: " + Arrays.toString(command2));
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        try {
            Process process2 = new ProcessBuilder((String[])command2).start();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            final class StreamReader
            implements Callable<String> {
                private final InputStream in;

                StreamReader(InputStream in2) {
                    this.in = in2;
                }

                @Override
                public String call() throws Exception {
                    BufferedReader reader2 = new BufferedReader(new InputStreamReader(this.in));
                    return Utility.readFully(reader2);
                }
            }
            FutureTask<String> inReaderTask = new FutureTask<String>(new StreamReader(process2.getInputStream()));
            threadPool.execute(inReaderTask);
            FutureTask<String> errReaderTask = new FutureTask<String>(new StreamReader(process2.getErrorStream()));
            threadPool.execute(errReaderTask);
            int exitCode = process2.waitFor();
            String processOutput = inReaderTask.get();
            if (!Utility.isBlank(processOutput)) {
                LOGGER.log(Level.INFO, processOutput);
            }
            String processError = errReaderTask.get();
            if (exitCode != 0) {
                throw new IOException(String.format("Process returned exit code %d\n%s", exitCode, processError));
            }
            if (!Utility.isBlank(processError)) {
                LOGGER.log(Level.WARNING, processError);
            }
        }
        catch (SecurityException e2) {
            throw new IOException(e2.getMessage(), e2);
        }
        catch (ExecutionException e3) {
            throw new IOException(e3.getMessage(), e3);
        }
        catch (InterruptedException e4) {
            throw new IOException(e4.getMessage(), e4);
        }
        finally {
            threadPool.shutdown();
        }
    }

    File getDiagramFile() {
        return this.diagramFile;
    }

    final File getDotFile() {
        return this.dotFile;
    }

    final String getGraphOutputFormat() {
        return this.graphOutputFormat;
    }
}

