/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.maven;

import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.InfoLevel;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import sf.util.ObjectToString;
import sf.util.Utility;

public class SchemaCrawlerMojo
extends AbstractMavenReport
implements MavenReport {
    private MavenProject project;
    private String jdbcDriverClasspath;
    private String config;
    private String configOverride;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String command;
    private final String sorttables = "true";
    private final String sortcolumns = "false";
    private final String sortinout = "false";
    private final String infolevel = InfoLevel.standard.name();
    private final String schemas = ".*";
    private String table_types;
    private final String show_stored_procedures = Boolean.TRUE.toString();
    private final String tables = ".*";
    private final String excludecolumns = "";
    private final String procedures = ".*";
    private final String excludeinout = "";

    public String getDescription(Locale locale) {
        return "SchemaCrawler Report";
    }

    public String getName(Locale locale) {
        return "SchemaCrawler Report";
    }

    public String getOutputName() {
        return "schemacrawler";
    }

    private OutputOptions createOutputOptions(File outputFile) {
        OutputOptions outputOptions = new OutputOptions();
        outputOptions.setOutputFormatValue(OutputFormat.html.name());
        outputOptions.setAppendOutput(false);
        outputOptions.setNoHeader(true);
        outputOptions.setNoFooter(true);
        outputOptions.setOutputFileName(outputFile.getAbsolutePath());
        return outputOptions;
    }

    private SchemaCrawlerOptions createSchemaCrawlerOptions() {
        SchemaCrawlerOptions schemaCrawlerOptions = new SchemaCrawlerOptions();
        if (!Utility.isBlank(this.table_types)) {
            schemaCrawlerOptions.setTableTypes(this.table_types);
        }
        schemaCrawlerOptions.setShowStoredProcedures(Boolean.parseBoolean(this.show_stored_procedures));
        schemaCrawlerOptions.setAlphabeticalSortForTables(Boolean.parseBoolean("true"));
        schemaCrawlerOptions.setAlphabeticalSortForTableColumns(Boolean.parseBoolean("false"));
        schemaCrawlerOptions.setAlphabeticalSortForProcedureColumns(Boolean.parseBoolean("false"));
        schemaCrawlerOptions.setSchemaInfoLevel(InfoLevel.valueOf(this.infolevel).getSchemaInfoLevel());
        schemaCrawlerOptions.setSchemaInclusionRule(new InclusionRule(".*", ""));
        schemaCrawlerOptions.setTableInclusionRule(new InclusionRule(".*", ""));
        schemaCrawlerOptions.setProcedureInclusionRule(new InclusionRule(".*", ""));
        schemaCrawlerOptions.setColumnInclusionRule(new InclusionRule(".*", ""));
        schemaCrawlerOptions.setProcedureColumnInclusionRule(new InclusionRule(".*", ""));
        return schemaCrawlerOptions;
    }

    private void fixClassPath() throws MavenReportException {
        URL[] jdbcJarUrls = new URL[]{};
        try {
            String[] jdbcJarPaths = this.jdbcDriverClasspath.split(System.getProperty("path.separator"));
            jdbcJarUrls = new URL[jdbcJarPaths.length];
            for (int i = 0; i < jdbcJarPaths.length; ++i) {
                String jdbcJarPath = jdbcJarPaths[i];
                jdbcJarUrls[i] = new File(jdbcJarPath).getCanonicalFile().toURI().toURL();
            }
            Method addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            URLClassLoader classLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
            addUrlMethod.setAccessible(true);
            for (URL jdbcJarUrl : jdbcJarUrls) {
                addUrlMethod.invoke((Object)classLoader, jdbcJarUrl);
            }
            this.getLog().info((CharSequence)("Fixed SchemaCrawler classpath: " + Arrays.asList(classLoader.getURLs())));
        }
        catch (Exception e2) {
            throw new MavenReportException("Error fixing classpath with " + Arrays.asList(jdbcJarUrls), e2);
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        try {
            this.fixClassPath();
            File outputFile = File.createTempFile("schemacrawler.report.", ".html");
            Config additionalConfiguration = Config.load(this.config, this.configOverride);
            executable.setOutputOptions(this.createOutputOptions(outputFile));
            executable.setSchemaCrawlerOptions(this.createSchemaCrawlerOptions());
            executable.setAdditionalConfiguration(additionalConfiguration);
            DatabaseConnectionOptions connectionOptions = new DatabaseConnectionOptions(this.driver, this.url);
            connectionOptions.setUser(this.user);
            connectionOptions.setPassword(this.password);
            this.getLog().debug((CharSequence)ObjectToString.toString(executable));
            executable.execute(connectionOptions.createConnection());
            String styleSheet = Utility.readResourceFully("/schemacrawler-report-output.css");
            Sink sink = this.getSink();
            this.getLog().info((CharSequence)sink.getClass().getName());
            sink.head();
            sink.title();
            sink.text("SchemaCrawler Report");
            sink.title_();
            sink.rawText("<style type='text/css'>" + Utility.NEWLINE + styleSheet + Utility.NEWLINE + "  </style>" + Utility.NEWLINE);
            sink.head_();
            sink.body();
            sink.rawText(Utility.readFully(new FileReader(outputFile)));
            sink.body_();
            sink.flush();
            sink.close();
        }
        catch (Exception e2) {
            throw new MavenReportException("Error executing:\n" + ObjectToString.toString(executable), e2);
        }
    }

    protected String getOutputDirectory() {
        return null;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return null;
    }
}

