/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.util.TextFormattingHelper;
import schemacrawler.utility.SchemaCrawlerUtility;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataTextFormatter
extends BaseFormatter<OperationOptions> {
    private static final Logger LOGGER = Logger.getLogger(DataTextFormatter.class.getName());
    private static final String NULL = "<null>";
    private static final String BINARY = "<binary>";
    private int dataBlockCount;
    private final Operation operation;

    DataTextFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, false, outputOptions);
        this.operation = operation;
    }

    private String convertColumnDataToString(ResultsColumn[] resultsColumns, ResultSet rows2, int i) throws SQLException {
        String columnDataString;
        int javaSqlType = resultsColumns[i].getType().getType();
        if (javaSqlType == 2005) {
            Clob clob = rows2.getClob(i + 1);
            columnDataString = rows2.wasNull() || clob == null ? NULL : this.readClob(clob);
        } else if (javaSqlType == 2007) {
            NClob nClob = rows2.getNClob(i + 1);
            columnDataString = rows2.wasNull() || nClob == null ? NULL : this.readClob(nClob);
        } else if (javaSqlType == 2004) {
            Blob blob = rows2.getBlob(i + 1);
            columnDataString = rows2.wasNull() || blob == null ? NULL : this.readBlob(blob);
        } else if (javaSqlType == -4) {
            InputStream stream2 = rows2.getBinaryStream(i + 1);
            columnDataString = rows2.wasNull() || stream2 == null ? NULL : this.readStream(stream2);
        } else if (javaSqlType == -10 || javaSqlType == -1) {
            InputStream stream3 = rows2.getAsciiStream(i + 1);
            columnDataString = rows2.wasNull() || stream3 == null ? NULL : this.readStream(stream3);
        } else {
            Object columnData = rows2.getObject(i + 1);
            columnDataString = rows2.wasNull() || columnData == null ? NULL : columnData.toString();
        }
        return columnDataString;
    }

    private void doHandleOneRow(List<String> row2, String lastColumnData) {
        if (row2.isEmpty()) {
            return;
        }
        ArrayList<String> outputRow = new ArrayList<String>();
        outputRow.addAll(row2);
        outputRow.add(lastColumnData);
        String[] columnData = outputRow.toArray(new String[outputRow.size()]);
        this.out.println(this.formattingHelper.createRow(columnData));
    }

    private String getMessage(double aggregate2) {
        Number number2 = Math.abs(aggregate2 - (double)((int)aggregate2)) < 1.0E-10 ? (Number)((int)aggregate2) : (Number)aggregate2;
        String message = this.operation.getCountMessage(number2);
        return message;
    }

    private void handleAggregateOperationForTable(String title2, ResultSet results2) throws SchemaCrawlerException {
        long aggregate2 = 0L;
        try {
            if (results2.next()) {
                aggregate2 = results2.getLong(1);
            }
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Could not obtain aggregate data", e2);
        }
        String message = this.getMessage(aggregate2);
        this.out.println(this.formattingHelper.createNameRow(title2, message, false));
    }

    private void iterateRows(ResultsColumn[] resultsColumns, ResultSet rows2) throws SQLException {
        while (rows2.next()) {
            int columnCount = resultsColumns.length;
            ArrayList<String> currentRow = new ArrayList<String>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String columnDataString = this.convertColumnDataToString(resultsColumns, rows2, i);
                currentRow.add(columnDataString);
            }
            String[] columnData = currentRow.toArray(new String[currentRow.size()]);
            this.out.println(this.formattingHelper.createRow(columnData));
        }
    }

    private void iterateRowsAndMerge(ResultsColumn[] resultsColumns, ResultSet rows2) throws SQLException {
        int columnCount = resultsColumns.length;
        ArrayList<String> previousRow = new ArrayList<String>();
        StringBuilder currentRowLastColumn = new StringBuilder();
        while (rows2.next()) {
            ArrayList<String> currentRow = new ArrayList<String>(columnCount - 1);
            for (int i = 0; i < columnCount - 1; ++i) {
                String columnDataString = this.convertColumnDataToString(resultsColumns, rows2, i);
                currentRow.add(columnDataString);
            }
            String lastColumnDataString = this.convertColumnDataToString(resultsColumns, rows2, resultsColumns.length - 1);
            if (((Object)currentRow).equals(previousRow)) {
                currentRowLastColumn.append(lastColumnDataString);
            } else {
                this.doHandleOneRow(previousRow, currentRowLastColumn.toString());
                currentRowLastColumn = new StringBuilder();
                currentRowLastColumn.append(lastColumnDataString);
            }
            previousRow = currentRow;
        }
        this.doHandleOneRow(previousRow, currentRowLastColumn.toString());
    }

    private void printHeader() {
        if (this.operation != null) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, this.operation.getDescription()));
        } else {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Query"));
        }
        if (this.operation == Operation.count) {
            this.out.println(this.formattingHelper.createObjectStart(this.operation.getDescription()));
        }
    }

    private String readBlob(Blob blob) {
        if (blob == null) {
            return NULL;
        }
        if (((OperationOptions)this.options).isShowLobs()) {
            String lobData;
            InputStream in2 = null;
            try {
                try {
                    in2 = blob.getBinaryStream();
                }
                catch (SQLFeatureNotSupportedException e2) {
                    in2 = null;
                }
                lobData = in2 != null ? Utility.readFully(in2) : BINARY;
            }
            catch (SQLException e3) {
                LOGGER.log(Level.WARNING, "Could not read BLOB data", e3);
                lobData = BINARY;
            }
            return lobData;
        }
        return BINARY;
    }

    private String readClob(Clob clob) {
        if (clob == null) {
            return NULL;
        }
        if (((OperationOptions)this.options).isShowLobs()) {
            String lobData;
            Reader rdr = null;
            try {
                try {
                    rdr = new InputStreamReader(clob.getAsciiStream());
                }
                catch (SQLFeatureNotSupportedException e2) {
                    rdr = null;
                }
                if (rdr == null) {
                    try {
                        rdr = clob.getCharacterStream();
                    }
                    catch (SQLFeatureNotSupportedException e3) {
                        rdr = null;
                    }
                }
                if (rdr != null) {
                    lobData = Utility.readFully(rdr);
                    if (lobData.length() == 0) {
                        long clobLength = clob.length();
                        lobData = clob.getSubString(1L, (int)clobLength);
                    }
                } else {
                    lobData = BINARY;
                }
            }
            catch (SQLException e4) {
                LOGGER.log(Level.WARNING, "Could not read CLOB data", e4);
                lobData = BINARY;
            }
            return lobData;
        }
        return BINARY;
    }

    private String readStream(InputStream stream2) {
        if (stream2 == null) {
            return NULL;
        }
        if (((OperationOptions)this.options).isShowLobs()) {
            BufferedInputStream in2 = new BufferedInputStream(stream2);
            String lobData = Utility.readFully(in2);
            return lobData;
        }
        return BINARY;
    }

    void begin() {
        if (!this.outputOptions.isNoHeader()) {
            this.out.println(this.formattingHelper.createDocumentStart());
        }
    }

    void end() {
        if (this.operation == Operation.count) {
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        if (!this.outputOptions.isNoFooter()) {
            this.out.println(this.formattingHelper.createDocumentEnd());
        }
        this.out.flush();
        this.outputOptions.closeOutputWriter(this.out);
    }

    void handleData(String title2, ResultSet rows2) throws SchemaCrawlerException {
        if (this.dataBlockCount == 0) {
            this.printHeader();
        }
        if (this.operation == Operation.count) {
            this.handleAggregateOperationForTable(title2, rows2);
        } else {
            this.out.println(this.formattingHelper.createObjectStart(title2));
            try {
                ResultsColumn[] resultsColumns = SchemaCrawlerUtility.getResultColumns(rows2).getColumns();
                int columnCount = resultsColumns.length;
                String[] columnNames = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    columnNames[i] = resultsColumns[i].getName();
                }
                this.out.println(this.formattingHelper.createRowHeader(columnNames));
                if (((OperationOptions)this.options).isMergeRows() && columnCount > 1) {
                    this.iterateRowsAndMerge(resultsColumns, rows2);
                } else {
                    this.iterateRows(resultsColumns, rows2);
                }
            }
            catch (SQLException e2) {
                throw new SchemaCrawlerException(e2.getMessage(), e2);
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        ++this.dataBlockCount;
    }
}

