/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationHandler;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.Query;

public final class OperationExecutable
extends BaseExecutable {
    private static final long serialVersionUID = -6824567755397315920L;
    private OperationOptions operationOptions;

    public OperationExecutable(String command2) {
        super(command2);
    }

    public final OperationOptions getOperationOptions() {
        OperationOptions operationOptions = this.operationOptions == null ? new OperationOptions(this.additionalConfiguration) : this.operationOptions;
        return operationOptions;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = operationOptions;
    }

    protected void executeOn(Database database, Connection connection) throws Exception {
        OperationHandler handler = this.getHandler(connection);
        handler.begin();
        handler.handle(database.getSchemaCrawlerInfo(), database.getDatabaseInfo(), database.getJdbcDriverInfo());
        for (Schema schema : database.getSchemas()) {
            Table[] tables;
            for (Table table2 : tables = schema.getTables()) {
                handler.handle(table2);
            }
        }
        handler.end();
    }

    protected OperationHandler getHandler(Connection connection) throws SchemaCrawlerException {
        Query query2;
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException e2) {
            operation = null;
        }
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration != null ? (String)this.additionalConfiguration.get(queryName) : null;
            query2 = new Query(queryName, queryString);
        } else {
            query2 = operation.getQuery();
        }
        OperationOptions operationOptions = this.getOperationOptions();
        OperationHandler handler = new OperationHandler(operation, query2, operationOptions, this.outputOptions, connection);
        return handler;
    }
}

