/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.Query;

final class OperationHandler {
    private static final Logger LOGGER = Logger.getLogger(OperationHandler.class.getName());
    private final Connection connection;
    private final DataTextFormatter dataFormatter;
    private final Query query;

    OperationHandler(Operation operation, Query query2, OperationOptions options, OutputOptions outputOptions, Connection connection) throws SchemaCrawlerException {
        if (connection == null) {
            throw new SchemaCrawlerException("No connection provided");
        }
        this.connection = connection;
        if (query2 == null) {
            throw new SchemaCrawlerException("No query provided");
        }
        this.query = query2;
        if (options == null) {
            throw new SchemaCrawlerException("No operation options provided");
        }
        this.dataFormatter = new DataTextFormatter(operation, options, outputOptions);
    }

    public void handle(SchemaCrawlerInfo schemaCrawlerInfo, DatabaseInfo databaseInfo, JdbcDriverInfo jdbcDriverInfo) throws SchemaCrawlerException {
        this.dataFormatter.handle(schemaCrawlerInfo, databaseInfo, jdbcDriverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlAndHandleData(String title2, String sql) throws SchemaCrawlerException {
        LOGGER.log(Level.FINE, String.format("Executing query for %s: %s", title2, sql));
        Statement statement = null;
        ResultSet results2 = null;
        try {
            statement = this.connection.createStatement();
            boolean hasResults = statement.execute(sql);
            if (hasResults) {
                results2 = statement.getResultSet();
                this.dataFormatter.handleData(title2, results2);
            }
        }
        catch (SQLException e2) {
            LOGGER.log(Level.WARNING, "Error executing: " + sql, e2);
        }
        finally {
            try {
                if (results2 != null) {
                    results2.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e3) {
                LOGGER.log(Level.WARNING, "Error releasing resources", e3);
            }
        }
    }

    void begin() throws SchemaCrawlerException {
        try {
            if (this.connection.isClosed()) {
                throw new SchemaCrawlerException("Connection is closed");
            }
        }
        catch (SQLException e2) {
            throw new SchemaCrawlerException("Connection is closed", e2);
        }
        this.dataFormatter.begin();
    }

    void end() throws SchemaCrawlerException {
        if (!this.query.isQueryOver()) {
            String title2 = this.query.getName();
            String sql = this.query.getQuery();
            this.executeSqlAndHandleData(title2, sql);
        }
        this.dataFormatter.end();
    }

    void handle(Table table2) throws SchemaCrawlerException {
        if (this.query.isQueryOver()) {
            String title2 = table2.getFullName();
            String sql = this.query.getQueryForTable(table2);
            this.executeSqlAndHandleData(title2, sql);
        }
    }
}

