/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import schemacrawler.crawl.JavaSqlType;
import schemacrawler.crawl.JavaSqlTypesUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 2820769346069413473L;
    private final String name;
    private final String query;

    private static String getOrderByColumnsListAsString(Table table2) {
        Column[] columnsArray = table2.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < columnsArray.length; ++i) {
            Column column = columnsArray[i];
            JavaSqlType.JavaSqlTypeGroup javaSqlTypeGroup = JavaSqlTypesUtility.lookupSqlDataType(column.getType().getType()).getJavaSqlTypeGroup();
            if (javaSqlTypeGroup == JavaSqlType.JavaSqlTypeGroup.large_object) continue;
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(column.getName());
        }
        return buffer.toString();
    }

    public Query(String name, String query2) {
        if (Utility.isBlank(name)) {
            throw new IllegalArgumentException("No name provided for the query");
        }
        this.name = name;
        if (Utility.isBlank(query2)) {
            throw new IllegalArgumentException("No SQL provided for query '" + name + "'");
        }
        this.query = query2;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return TemplatingUtility.expandTemplate(this.query);
    }

    public String getQueryForTable(Table table2) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table2 != null) {
            if (table2.getSchema() != null) {
                tableProperties.put("schema", table2.getSchema().getFullName());
            }
            tableProperties.put("table", table2.getFullName());
            tableProperties.put("columns", table2.getColumnsListAsString());
            tableProperties.put("orderbycolumns", Query.getOrderByColumnsListAsString(table2));
            tableProperties.put("tabletype", table2.getType().toString());
        }
        String sql = this.query;
        sql = TemplatingUtility.expandTemplate(sql, tableProperties);
        sql = TemplatingUtility.expandTemplate(sql);
        return sql;
    }

    public boolean isQueryOver() {
        Set<String> keys2 = TemplatingUtility.extractTemplateVariables(this.query);
        return keys2.contains("table");
    }

    public String toString() {
        return this.name + ":" + this.query;
    }
}

