/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.util;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.util.TableCell;
import schemacrawler.tools.text.util.TableRow;
import schemacrawler.tools.text.util.TextFormattingHelper;
import sf.util.Utility;

abstract class BaseTextFormattingHelper
implements TextFormattingHelper {
    static final String DASHED_SEPARATOR = BaseTextFormattingHelper.separator("-");
    private final OutputFormat outputFormat;

    static String separator(String pattern) {
        StringBuilder dashedSeparator = new StringBuilder();
        for (int i = 0; i < 72 / pattern.length(); ++i) {
            dashedSeparator.append(pattern);
        }
        return dashedSeparator.toString();
    }

    BaseTextFormattingHelper(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String createDefinitionRow(String definition) {
        TableRow row2 = new TableRow(this.outputFormat);
        row2.add(new TableCell("", "ordinal", this.outputFormat));
        row2.add(new TableCell(definition, 0, TableCell.Align.left, 2, "definition", this.outputFormat));
        return row2.toString();
    }

    public String createDetailRow(String ordinal, String subName, String type) {
        int subNameWidth = 32;
        int typeWidth = 28;
        TableRow row2 = new TableRow(this.outputFormat);
        if (Utility.isBlank(ordinal)) {
            row2.add(new TableCell("", "ordinal", this.outputFormat));
        } else {
            row2.add(new TableCell(ordinal, 2, TableCell.Align.left, 1, "ordinal", this.outputFormat));
        }
        row2.add(new TableCell(subName, 32, TableCell.Align.left, 1, "subname", this.outputFormat));
        row2.add(new TableCell(type, 28, TableCell.Align.left, 1, "type", this.outputFormat));
        return row2.toString();
    }

    public String createEmptyRow() {
        return new TableRow(this.outputFormat, 4).toString();
    }

    public String createNameRow(String name, String description2, boolean underscore) {
        int nameWidth = 34;
        int descriptionWidth = 36;
        if (name.length() > nameWidth && description2.length() < descriptionWidth) {
            descriptionWidth = Math.max(description2.length(), descriptionWidth - (name.length() - nameWidth));
        }
        if (description2.length() > descriptionWidth && name.length() < nameWidth) {
            nameWidth = Math.max(name.length(), nameWidth - (description2.length() - descriptionWidth));
        }
        TableRow row2 = new TableRow(this.outputFormat);
        row2.add(new TableCell(name, nameWidth, TableCell.Align.left, 2, "name" + (underscore ? " underscore" : ""), this.outputFormat));
        row2.add(new TableCell(description2, descriptionWidth, TableCell.Align.right, 1, "description" + (underscore ? " underscore" : ""), this.outputFormat));
        String nameRowString = row2.toString();
        if (underscore && this.outputFormat != OutputFormat.html) {
            nameRowString = nameRowString + Utility.NEWLINE + DASHED_SEPARATOR;
        }
        return nameRowString;
    }

    public String createNameValueRow(String name, String value2) {
        int nameWidth = 36;
        TableRow row2 = new TableRow(this.outputFormat);
        row2.add(new TableCell(name, 36, TableCell.Align.left, 1, "", this.outputFormat));
        row2.add(new TableCell(value2, "", this.outputFormat));
        return row2.toString();
    }

    public String createRow(String[] columnData) {
        OutputFormat outputFormat = this.outputFormat;
        if (outputFormat == OutputFormat.text) {
            outputFormat = OutputFormat.csv;
        }
        TableRow row2 = new TableRow(outputFormat);
        for (String element2 : columnData) {
            row2.add(new TableCell(element2, "", outputFormat));
        }
        return row2.toString();
    }

    public String createRowHeader(String[] columnNames) {
        OutputFormat outputFormat = this.outputFormat;
        if (outputFormat == OutputFormat.text) {
            outputFormat = OutputFormat.csv;
        }
        TableRow row2 = new TableRow(outputFormat);
        for (String columnName2 : columnNames) {
            row2.add(new TableCell(columnName2, "name", outputFormat));
        }
        return row2.toString();
    }
}

