/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.util;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.util.Entities;
import sf.util.Utility;

final class TableCell {
    private final OutputFormat outputFormat;
    private final String styleClass;
    private final int colSpan;
    private final int characterWidth;
    private final Align align;
    private final String text;

    private static String escapeAndQuoteCsv(String text2) {
        int QUOTE = 34;
        int SEPARATOR = 44;
        String value2 = String.valueOf(text2);
        int length2 = value2.length();
        if (length2 == 0) {
            return "\"\"";
        }
        if (value2.indexOf(44) < 0 && value2.indexOf(34) < 0) {
            return value2;
        }
        StringBuilder sb = new StringBuilder(length2);
        sb.append('\"');
        for (int i = 0; i < length2; ++i) {
            char c2 = value2.charAt(i);
            if (c2 == '\"') {
                sb.append('\"').append(c2);
                continue;
            }
            sb.append(c2);
        }
        sb.append('\"');
        return sb.toString();
    }

    TableCell(String text2, int characterWidth, Align align, int colSpan, String styleClass, OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        this.colSpan = colSpan;
        this.styleClass = styleClass;
        this.text = text2;
        this.characterWidth = characterWidth;
        this.align = align;
    }

    TableCell(String text2, String styleClass, OutputFormat outputFormat) {
        this(text2, 0, Align.left, 1, styleClass, outputFormat);
    }

    public String toString() {
        if (this.outputFormat == OutputFormat.html) {
            return this.toHtmlString();
        }
        return this.toPlainTextString();
    }

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<td");
        if (this.colSpan > 1) {
            buffer.append(" colspan='").append(this.colSpan).append("'");
        }
        if (!Utility.isBlank(this.styleClass)) {
            buffer.append(" class='").append(this.styleClass).append("'");
        }
        buffer.append(">");
        buffer.append(Entities.XML.escape(String.valueOf(this.text)));
        buffer.append("</td>");
        return buffer.toString();
    }

    private String toPlainTextString() {
        if (this.outputFormat == OutputFormat.csv) {
            return TableCell.escapeAndQuoteCsv(this.text);
        }
        if (this.characterWidth > 0) {
            if (this.align == Align.right) {
                return String.format("%" + this.characterWidth + "s", this.text);
            }
            return String.format("%-" + this.characterWidth + "s", this.text);
        }
        return this.text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Align {
        left,
        right;

    }
}

