/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectToString {
    private static final Logger LOGGER = Logger.getLogger(ObjectToString.class.getName());

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        boolean indent2 = false;
        StringBuilder buffer = new StringBuilder();
        ObjectToString.appendObject(object, 0, buffer);
        return buffer.toString();
    }

    private static void appendFields(Object object, int indent2, StringBuilder buffer) {
        if (object == null) {
            return;
        }
        for (Field field2 : ObjectToString.getFields(object)) {
            try {
                String fieldName = field2.getName();
                Object fieldValue = field2.get(object);
                Class<?> fieldType = field2.getType();
                if (fieldValue != null && fieldType.isArray()) {
                    fieldValue = Arrays.toString((Object[])fieldValue);
                }
                buffer.append(ObjectToString.indent(indent2)).append("  ").append(fieldName).append(": ");
                if (fieldType.isPrimitive() || fieldType.isEnum() || fieldValue instanceof String || fieldValue == null || ObjectToString.definesToString(fieldValue)) {
                    buffer.append(fieldValue);
                } else {
                    ObjectToString.appendObject(fieldValue, indent2 + 1, buffer);
                }
                buffer.append(Utility.NEWLINE);
            }
            catch (Exception e2) {
                LOGGER.log(Level.FINER, "Could not access field, " + field2, e2);
            }
        }
    }

    private static void appendFooter(int indent2, StringBuilder buffer) {
        buffer.append(ObjectToString.indent(indent2)).append("]");
    }

    private static void appendHeader(Object object, int indent2, StringBuilder buffer) {
        if (object != null) {
            buffer.append(ObjectToString.indent(indent2)).append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object))).append("[").append(Utility.NEWLINE);
        }
    }

    private static void appendObject(Object object, int indent2, StringBuilder buffer) {
        Class<?> objectClass = object.getClass();
        if (Map.class.isAssignableFrom(objectClass)) {
            Set mapEntries = new TreeMap((Map)object).entrySet();
            for (Map.Entry mapEntry : mapEntries) {
                buffer.append(Utility.NEWLINE).append(ObjectToString.indent(indent2)).append(mapEntry.getKey()).append(": ").append(mapEntry.getValue());
            }
        } else if (Collection.class.isAssignableFrom(objectClass)) {
            Iterator iterator2 = ((Collection)object).iterator();
            while (iterator2.hasNext()) {
                Object item = iterator2.next();
                buffer.append(item);
                if (!iterator2.hasNext()) continue;
                buffer.append(", ");
            }
        } else if (objectClass.isArray()) {
            Iterator<Object> iterator3 = Arrays.asList((Object[])object).iterator();
            while (iterator3.hasNext()) {
                Object item = iterator3.next();
                buffer.append(item);
                if (!iterator3.hasNext()) continue;
                buffer.append(", ");
            }
        } else if (objectClass.isEnum()) {
            buffer.append(object.toString());
        } else if (Arrays.asList(Integer.class, Long.class, Double.class, Float.class, Boolean.class, Character.class, Byte.class, Void.class, Short.class, String.class).contains(objectClass)) {
            buffer.append(object.toString());
        } else {
            ObjectToString.appendHeader(object, 0, buffer);
            ObjectToString.appendFields(object, indent2, buffer);
            ObjectToString.appendFooter(indent2, buffer);
        }
    }

    private static boolean definesToString(Object object) {
        boolean definesToString = false;
        Class<?>[] classes2 = ObjectToString.getClassHierarchy(object);
        if (classes2.length > 0) {
            for (Class<?> clazz2 : classes2) {
                try {
                    boolean bl = definesToString = clazz2.getDeclaredMethod("toString", new Class[0]) != null;
                    if (!definesToString) continue;
                    break;
                }
                catch (SecurityException e2) {
                }
                catch (NoSuchMethodException e3) {
                    // empty catch block
                }
            }
        }
        return definesToString;
    }

    private static Class<?>[] getClassHierarchy(Object object) {
        ArrayList classHierarchy = new ArrayList();
        if (object != null) {
            Class<?> clazz2 = object.getClass();
            classHierarchy.add(clazz2);
            while (clazz2.getSuperclass() != null) {
                if ((clazz2 = clazz2.getSuperclass()).getSuperclass() == null) continue;
                classHierarchy.add(clazz2);
            }
        }
        return classHierarchy.toArray(new Class[classHierarchy.size()]);
    }

    private static Field[] getFields(Object object) {
        Class<?>[] classes2 = ObjectToString.getClassHierarchy(object);
        ArrayList<AccessibleObject> allFields = new ArrayList<AccessibleObject>();
        if (classes2 != null && classes2.length > 0) {
            Class<?> clazz2;
            Class<?>[] arr$ = classes2;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (clazz2 = arr$[i$]).isArray() || clazz2.isPrimitive() || clazz2.isEnum() || String.class.isAssignableFrom(clazz2)); ++i$) {
                AccessibleObject[] fields = clazz2.getDeclaredFields();
                AccessibleObject.setAccessible(fields, true);
                allFields.addAll(Arrays.asList(fields));
            }
        }
        Iterator iterator2 = allFields.iterator();
        while (iterator2.hasNext()) {
            Field field2 = (Field)iterator2.next();
            int modifiers = field2.getModifiers();
            if (!Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers)) continue;
            iterator2.remove();
        }
        Collections.sort(allFields, new Comparator<Field>(){

            @Override
            public int compare(Field field1, Field field2) {
                return field1.getName().compareTo(field2.getName());
            }
        });
        return allFields.toArray(new Field[allFields.size()]);
    }

    private static char[] indent(int indent2) {
        if (indent2 >= 0) {
            char[] indentChars = new char[indent2 * 2];
            Arrays.fill(indentChars, ' ');
            return indentChars;
        }
        return new char[0];
    }

    private ObjectToString() {
    }
}

