/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplatingUtility {
    private static final String DELIMITER_START = "${";
    private static final String DELIMITER_END = "}";

    public static String expandTemplate(String template) {
        return TemplatingUtility.expandTemplate(template, TemplatingUtility.propertiesMap(System.getProperties()));
    }

    public static String expandTemplate(String template, Map<String, String> variablesMap) {
        if (Utility.isBlank(template) || variablesMap == null) {
            return template;
        }
        StringBuilder buffer = new StringBuilder();
        int currentPosition = 0;
        while (true) {
            int delimiterStartPosition;
            if ((delimiterStartPosition = template.indexOf(DELIMITER_START, currentPosition)) == -1) {
                if (currentPosition == 0) {
                    return template;
                }
                buffer.append(template.substring(currentPosition, template.length()));
                return buffer.toString();
            }
            buffer.append(template.substring(currentPosition, delimiterStartPosition));
            int delimiterEndPosition = template.indexOf(DELIMITER_END, delimiterStartPosition);
            if (delimiterEndPosition > -1) {
                String key = template.substring(delimiterStartPosition += DELIMITER_START.length(), delimiterEndPosition);
                String value2 = variablesMap.get(key);
                if (value2 != null) {
                    buffer.append(value2);
                } else {
                    buffer.append(DELIMITER_START).append(key).append(DELIMITER_END);
                }
                currentPosition = delimiterEndPosition + DELIMITER_END.length();
                continue;
            }
            buffer.append(DELIMITER_START);
            currentPosition = delimiterStartPosition + DELIMITER_START.length();
        }
    }

    public static Set<String> extractTemplateVariables(String template) {
        int right2;
        int left2;
        if (Utility.isBlank(template)) {
            return new HashSet<String>();
        }
        String shrunkTemplate = template;
        HashSet<String> keys2 = new HashSet<String>();
        while ((left2 = shrunkTemplate.indexOf(DELIMITER_START)) >= 0 && (right2 = shrunkTemplate.indexOf(DELIMITER_END, left2 + 2)) >= 0) {
            String propertyKey = shrunkTemplate.substring(left2 + 2, right2);
            keys2.add(propertyKey);
            shrunkTemplate = shrunkTemplate.substring(0, left2) + shrunkTemplate.substring(right2 + 1);
        }
        return keys2;
    }

    public static void substituteVariables(Map<String, String> variablesMap) {
        if (variablesMap != null && !variablesMap.isEmpty()) {
            for (Map.Entry<String, String> entry2 : variablesMap.entrySet()) {
                variablesMap.put(entry2.getKey(), TemplatingUtility.expandTemplate(entry2.getValue(), variablesMap));
            }
        }
    }

    private static Map<String, String> propertiesMap(Properties properties2) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties2 != null) {
            Set<Map.Entry<Object, Object>> entries = properties2.entrySet();
            for (Map.Entry<Object, Object> entry2 : entries) {
                propertiesMap.put((String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        return propertiesMap;
    }

    private TemplatingUtility() {
    }
}

