/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.custommonkey.xmlunit.Validator;
import schemacrawler.tools.options.OutputFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtility {
    public static List<String> compareOutput(String referenceFile, File testOutputFile, OutputFormat outputFormat) throws Exception {
        boolean isOutputValidXml;
        if (!(testOutputFile != null && testOutputFile.exists() && testOutputFile.isFile() && testOutputFile.canRead() && testOutputFile.length() != 0L)) {
            return Collections.singletonList("Output file not created - " + testOutputFile.getAbsolutePath());
        }
        ArrayList<String> failures = new ArrayList<String>();
        InputStream referenceStream = TestUtility.class.getResourceAsStream("/" + referenceFile);
        boolean contentEquals = referenceStream == null ? false : TestUtility.contentEquals(new InputStreamReader(referenceStream), new FileReader(testOutputFile));
        if (outputFormat == OutputFormat.html) {
            BufferedReader reader2 = new BufferedReader(new FileReader(testOutputFile));
            Validator validator = new Validator((Reader)reader2);
            isOutputValidXml = validator.isValid();
            if (!isOutputValidXml) {
                failures.add(validator.toString());
            }
            ((Reader)reader2).close();
        } else {
            isOutputValidXml = true;
        }
        if (!contentEquals || !isOutputValidXml) {
            File testOutputLocalFile = new File("./", referenceFile);
            testOutputLocalFile.getParentFile().mkdirs();
            testOutputLocalFile.delete();
            boolean renamed = testOutputFile.renameTo(testOutputLocalFile);
            if (renamed) {
                if (!contentEquals) {
                    failures.add("Output does not match");
                }
                if (!isOutputValidXml) {
                    failures.add("Output is invalid XML");
                }
                failures.add("Actual output in " + testOutputLocalFile.getAbsolutePath());
                System.err.println(testOutputLocalFile.getAbsolutePath());
            } else {
                failures.add("Output does not match; could not rename file; see actual output in " + testOutputFile.getAbsolutePath());
            }
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean contentEquals(Reader expectedInputReader, Reader actualInputReader) throws Exception {
        if (expectedInputReader == null || actualInputReader == null) {
            return false;
        }
        BufferedReader expectedBufferedReader = new BufferedReader(expectedInputReader);
        BufferedReader actualBufferedReader = new BufferedReader(actualInputReader);
        try {
            String line;
            while ((line = expectedBufferedReader.readLine()) != null) {
                if (line.equals(actualBufferedReader.readLine())) continue;
                boolean bl = false;
                return bl;
            }
            if (actualBufferedReader.readLine() != null) {
                boolean bl = false;
                return bl;
            }
            if (expectedBufferedReader.readLine() != null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            expectedBufferedReader.close();
            actualBufferedReader.close();
        }
    }

    private TestUtility() {
    }
}

