/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class Utility {
    private static final Logger LOGGER = Logger.getLogger(Utility.class.getName());
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Pattern containsWhitespacePattern = Pattern.compile(".*\\s.*");

    public static String commonPrefix(String string1, String string2) {
        int index2 = Utility.indexOfDifference(string1, string2);
        if (index2 == -1) {
            return null;
        }
        return string1.substring(0, index2).toLowerCase();
    }

    public static boolean containsWhitespace(String text2) {
        if (text2 == null) {
            return false;
        }
        return containsWhitespacePattern.matcher(text2).matches();
    }

    public static String convertForComparison(String text2) {
        String textWithoutQuotes;
        if (!Utility.isBlank(text2)) {
            char[] charArray = text2.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char ch : charArray) {
                if (!Character.isLetterOrDigit(ch) && ch != '_' && ch != '.') continue;
                builder.append(Character.toLowerCase(ch));
            }
            textWithoutQuotes = builder.toString();
        } else {
            textWithoutQuotes = text2;
        }
        return textWithoutQuotes;
    }

    public static boolean isBlank(String text2) {
        int textLength;
        if (text2 == null || (textLength = text2.length()) == 0) {
            return true;
        }
        for (int i = 0; i < textLength; ++i) {
            if (Character.isWhitespace(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String readFully(InputStream stream2) {
        InputStreamReader reader2;
        if (stream2 == null) {
            return null;
        }
        try {
            reader2 = new InputStreamReader(stream2, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            LOGGER.log(Level.WARNING, e2.getMessage(), e2);
            return "";
        }
        return Utility.readFully(reader2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader2) {
        if (reader2 == null) {
            LOGGER.log(Level.WARNING, "Cannot read null reader");
            return "";
        }
        StringBuilder out = new StringBuilder();
        try {
            int read2;
            char[] buffer = new char[65536];
            do {
                BufferedReader bufferedReader;
                if ((read2 = ((Reader)(bufferedReader = new BufferedReader(reader2, buffer.length))).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read2);
            } while (read2 >= 0);
        }
        catch (UnsupportedEncodingException e2) {
            LOGGER.log(Level.WARNING, e2.getMessage(), e2);
        }
        catch (IOException e3) {
            LOGGER.log(Level.WARNING, "Could not read from reader", e3);
        }
        finally {
            try {
                reader2.close();
            }
            catch (IOException e4) {
                LOGGER.log(Level.WARNING, "Could not close reader", e4);
            }
        }
        return out.toString();
    }

    public static String readResourceFully(String resource) {
        return Utility.readFully(Utility.class.getResourceAsStream(resource));
    }

    public static void setApplicationLogLevel(Level logLevel) {
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Handler[] handlers;
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            logger.setLevel(null);
            for (Handler handler : handlers = logger.getHandlers()) {
                handler.setLevel(logLevel);
            }
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
    }

    private static int indexOfDifference(String string1, String string2) {
        int i;
        if (string1 == null || string2 == null) {
            return 0;
        }
        for (i = 0; i < string1.length() && i < string2.length() && string1.charAt(i) == string2.charAt(i); ++i) {
        }
        if (i < string2.length() || i < string1.length()) {
            return i;
        }
        return -1;
    }

    private Utility() {
    }
}

