/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config.migration;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.spin.tools.FileUtils;
import org.spin.tools.config.migration.ConfigFileType;
import org.spin.tools.config.migration.Transition;
import org.spin.tools.config.migration.Version;

public final class Migrate {
    private Migrate() {
    }

    private static final void usage() {
        System.out.println("Usage: Migrate <config file> <from version> <to version> <input file name>");
        System.out.println("Known config files and versions are: ");
        for (ConfigFileType configFile : ConfigFileType.values()) {
            System.out.println(" " + (Object)((Object)configFile));
            for (Version version : configFile.getKnownVersions()) {
                System.out.println("  " + (Object)((Object)version));
            }
        }
        System.out.println("Example:");
        System.out.println(" Migrate RoutingTable 1.8 1.9 routingtable.xml");
    }

    private static final void backup(File file, Version version) throws IOException {
        assert (file != null);
        File backupFile = new File(Migrate.getBackupFileName(file, version));
        System.out.println("Backing up '" + file + "' to '" + backupFile + "'");
        FileUtils.copy((File)file, (File)backupFile);
    }

    private static String getBackupFileName(File file, Version version) {
        return file.getAbsolutePath() + ".backup-" + (Object)((Object)version);
    }

    private static String getNewFileName(File file, Version version) {
        return file.getAbsolutePath() + ".new-" + (Object)((Object)version);
    }

    public static final void main(String[] args) throws Exception {
        if (args.length < 4) {
            Migrate.usage();
            System.exit(-1);
        }
        ConfigFileType configFileType = ConfigFileType.of(args[0]);
        Version fromVersion = Version.fromVersionString(args[1]);
        Version toVersion = Version.fromVersionString(args[2]);
        File file = new File(args[3]).getCanonicalFile();
        System.out.println("Migrating " + file + " from version " + (Object)((Object)fromVersion) + " to version " + (Object)((Object)toVersion));
        Migrate.backup(file, fromVersion);
        File newFile = new File(Migrate.getNewFileName(file, toVersion));
        configFileType.migrate(new FileReader(file), new Transition(fromVersion, toVersion), new FileWriter(newFile));
        System.out.println("New file wrote to '" + newFile + "'");
    }
}

