/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCheckConstraint;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class TableExRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableExRetriever.class.getName());

    TableExRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    private void createPrivileges(MetadataResultSet results, boolean privilegesForColumn) throws SQLException {
        while (results.next()) {
            MutablePrivilege privilege;
            String catalogName = this.quotedName(results.getString("TABLE_CAT"));
            String schemaName = this.quotedName(results.getString("TABLE_SCHEM"));
            String tableName = this.quotedName(results.getString("TABLE_NAME"));
            String columnName = privilegesForColumn ? this.quotedName(results.getString("COLUMN_NAME")) : null;
            MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
            if (table == null) continue;
            MutableColumn column = table.getColumn(columnName);
            if (privilegesForColumn && column == null) continue;
            String privilegeName = results.getString("PRIVILEGE");
            String grantor = results.getString("GRANTOR");
            String grantee = results.getString("GRANTEE");
            boolean isGrantable = results.getBoolean("IS_GRANTABLE");
            if (privilegesForColumn) {
                MutablePrivilege columnPrivilege = column.getPrivilege(privilegeName);
                if (columnPrivilege == null) {
                    privilege = new MutablePrivilege(column, privilegeName);
                    column.addPrivilege(privilege);
                } else {
                    privilege = columnPrivilege;
                }
            } else {
                MutablePrivilege tablePrivilege = table.getPrivilege(privilegeName);
                if (tablePrivilege == null) {
                    privilege = new MutablePrivilege(table, privilegeName);
                    table.addPrivilege(privilege);
                } else {
                    privilege = tablePrivilege;
                }
            }
            privilege.addGrant(grantor, grantee, isGrantable);
            privilege.addAttributes(results.getAttributes());
            if (privilegesForColumn) {
                column.addPrivilege(privilege);
                continue;
            }
            table.addPrivilege(privilege);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveCheckConstraintInformation() throws SQLException {
        MutableTable table;
        HashMap<String, MutableCheckConstraint> checkConstraintsMap = new HashMap<String, MutableCheckConstraint>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTableConstraintsSql()) {
            LOGGER.log(Level.FINE, "Table constraints SQL statement was not provided");
            return;
        }
        String tableConstraintsInformationSql = informationSchemaViews.getTableConstraints();
        Connection connection = this.getDatabaseConnection();
        Statement statement = null;
        MetadataResultSet results = null;
        try {
            statement = connection.createStatement();
            results = new MetadataResultSet(statement.executeQuery(tableConstraintsInformationSql));
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.quotedName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = this.quotedName(results.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint: " + constraintName);
                String tableName = this.quotedName(results.getString("TABLE_NAME"));
                table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                String constraintType = results.getString("CONSTRAINT_TYPE");
                boolean deferrable = results.getBoolean("IS_DEFERRABLE");
                boolean initiallyDeferred = results.getBoolean("INITIALLY_DEFERRED");
                if (!constraintType.equalsIgnoreCase("check")) continue;
                MutableCheckConstraint checkConstraint = new MutableCheckConstraint(table, constraintName);
                checkConstraint.setDeferrable(deferrable);
                checkConstraint.setInitiallyDeferred(initiallyDeferred);
                checkConstraint.addAttributes(results.getAttributes());
                checkConstraintsMap.put(constraintName, checkConstraint);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraint information", e);
            return;
        }
        finally {
            if (results != null) {
                results.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        if (!informationSchemaViews.hasCheckConstraintsSql()) {
            LOGGER.log(Level.FINE, "Check constraints SQL statement was not provided");
            return;
        }
        String checkConstraintInformationSql = informationSchemaViews.getCheckConstraints();
        statement = null;
        results = null;
        try {
            statement = connection.createStatement();
            results = new MetadataResultSet(statement.executeQuery(checkConstraintInformationSql));
            while (results.next()) {
                String constraintName = this.quotedName(results.getString("CONSTRAINT_NAME"));
                LOGGER.log(Level.FINER, "Retrieving constraint definition: " + constraintName);
                String definition = results.getString("CHECK_CLAUSE");
                MutableCheckConstraint checkConstraint = (MutableCheckConstraint)checkConstraintsMap.get(constraintName);
                if (checkConstraint == null) {
                    LOGGER.log(Level.FINEST, "Could not add check constraint to table: " + constraintName);
                    continue;
                }
                String text = checkConstraint.getDefinition();
                if (text != null && text.trim().length() != 0) {
                    definition = checkConstraint.getDefinition() + definition;
                }
                checkConstraint.setDefinition(definition);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        Collection checkConstraintsCollection = checkConstraintsMap.values();
        for (MutableCheckConstraint checkConstraint : checkConstraintsCollection) {
            table = (MutableTable)checkConstraint.getParent();
            table.addCheckConstraint(checkConstraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTableColumnPrivileges() throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getColumnPrivileges(null, null, "%", "%"));
            this.createPrivileges(results, true);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table column privileges:" + e.getMessage());
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTablePrivileges() throws SQLException {
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getTablePrivileges(null, null, "%"));
            this.createPrivileges(results, false);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table privileges", e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveTriggerInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasTriggerSql()) {
            LOGGER.log(Level.FINE, "Trigger definition SQL statement was not provided");
            return;
        }
        String triggerInformationSql = informationSchemaViews.getTriggers();
        Connection connection = this.getDatabaseConnection();
        Statement statement = connection.createStatement();
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(statement.executeQuery(triggerInformationSql));
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("TRIGGER_CATALOG"));
                String schemaName = this.quotedName(results.getString("TRIGGER_SCHEMA"));
                String triggerName = this.quotedName(results.getString("TRIGGER_NAME"));
                LOGGER.log(Level.FINER, "Retrieving trigger: " + triggerName);
                String tableName = results.getString("EVENT_OBJECT_TABLE");
                MutableTable table = this.lookupTable(catalogName, schemaName, tableName);
                if (table == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, tableName));
                    continue;
                }
                EventManipulationType eventManipulationType = results.getEnum("EVENT_MANIPULATION", EventManipulationType.unknown);
                int actionOrder = results.getInt("ACTION_ORDER", 0);
                String actionCondition = results.getString("ACTION_CONDITION");
                String actionStatement = results.getString("ACTION_STATEMENT");
                ActionOrientationType actionOrientation = results.getEnum("ACTION_ORIENTATION", ActionOrientationType.unknown);
                String conditionTimingString = results.getString("ACTION_TIMING");
                if (conditionTimingString == null) {
                    conditionTimingString = results.getString("CONDITION_TIMING");
                }
                ConditionTimingType conditionTiming = ConditionTimingType.valueOfFromValue(conditionTimingString);
                MutableTrigger trigger = table.lookupTrigger(triggerName);
                if (trigger == null) {
                    trigger = new MutableTrigger(table, triggerName);
                }
                trigger.setEventManipulationType(eventManipulationType);
                trigger.setActionOrder(actionOrder);
                trigger.appendActionCondition(actionCondition);
                trigger.appendActionStatement(actionStatement);
                trigger.setActionOrientation(actionOrientation);
                trigger.setConditionTiming(conditionTiming);
                trigger.addAttributes(results.getAttributes());
                table.addTrigger(trigger);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve trigger information", e);
        }
        finally {
            if (results != null) {
                results.close();
            }
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveViewInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasViewsSql()) {
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        String viewInformationSql = informationSchemaViews.getViews();
        Connection connection = this.getDatabaseConnection();
        Statement statement = connection.createStatement();
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(statement.executeQuery(viewInformationSql));
            while (results.next()) {
                String viewName;
                String schemaName;
                String catalogName = this.quotedName(results.getString("TABLE_CATALOG"));
                MutableView view = (MutableView)this.lookupTable(catalogName, schemaName = this.quotedName(results.getString("TABLE_SCHEMA")), viewName = this.quotedName(results.getString("TABLE_NAME")));
                if (view == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find table, %s.%s.%s", catalogName, schemaName, viewName));
                    continue;
                }
                LOGGER.log(Level.FINER, "Retrieving view information: " + viewName);
                String definition = results.getString("VIEW_DEFINITION");
                CheckOptionType checkOption = results.getEnum("CHECK_OPTION", CheckOptionType.unknown);
                boolean updatable = results.getBoolean("IS_UPDATABLE");
                view.appendDefinition(definition);
                view.setCheckOption(checkOption);
                view.setUpdatable(updatable);
                view.addAttributes(results.getAttributes());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not retrieve view information", e);
        }
        finally {
            if (results != null) {
                results.close();
            }
            statement.close();
        }
    }
}

