/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import sf.util.DirectedGraph;
import sf.util.GraphException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TablesGraph
extends DirectedGraph<MutableTable> {
    private static final Logger LOGGER = Logger.getLogger(TablesGraph.class.getName());

    TablesGraph(NamedObjectList<MutableTable> tables) {
        if (tables == null) {
            return;
        }
        for (MutableTable table : tables) {
            ForeignKey[] foreignKeys;
            this.addVertex(table);
            for (ForeignKey foreignKey : foreignKeys = table.getForeignKeys()) {
                ForeignKeyColumnMap[] columnPairs;
                for (ForeignKeyColumnMap columnPair : columnPairs = foreignKey.getColumnPairs()) {
                    this.addDirectedEdge((MutableTable)columnPair.getPrimaryKeyColumn().getParent(), (MutableTable)columnPair.getForeignKeyColumn().getParent());
                }
            }
        }
    }

    void setTablesSortIndices() {
        try {
            List sortedTables = this.topologicalSort();
            ArrayList<MutableView> sortedViews = new ArrayList<MutableView>();
            int sortIndex = 0;
            for (MutableTable table : sortedTables) {
                if (table instanceof MutableView) {
                    sortedViews.add((MutableView)table);
                    continue;
                }
                table.setSortIndex(sortIndex);
                ++sortIndex;
            }
            for (MutableView view : sortedViews) {
                view.setSortIndex(sortIndex);
                ++sortIndex;
            }
        }
        catch (GraphException e) {
            LOGGER.log(Level.CONFIG, e.getMessage());
        }
    }
}

