/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseExecutable;
import sf.util.FileUtility;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class ScriptExecutable
extends BaseExecutable {
    private static final long serialVersionUID = -2232328675306451328L;
    private static final Logger LOGGER = Logger.getLogger(ScriptExecutable.class.getName());

    public ScriptExecutable() {
        super("script");
    }

    public final void executeOn(Database database, Connection connection) throws Exception {
        InputStreamReader reader;
        String scriptFileName = this.outputOptions.getOutputFormatValue();
        if (Utility.isBlank(scriptFileName)) {
            throw new SchemaCrawlerException("No script file provided");
        }
        File scriptFile = new File(scriptFileName);
        if (scriptFile.exists() && scriptFile.canRead()) {
            reader = new FileReader(scriptFile);
        } else {
            InputStream inputStream = ScriptExecutable.class.getResourceAsStream("/" + scriptFileName);
            if (inputStream != null) {
                reader = new InputStreamReader(inputStream);
            } else {
                throw new SchemaCrawlerException("Cannot load script, " + scriptFileName);
            }
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
        ScriptEngineFactory scriptEngineFactory = null;
        ScriptEngineFactory javaScriptEngineFactory = null;
        for (ScriptEngineFactory engineFactory : engineFactories) {
            LOGGER.log(Level.FINER, String.format("Evaluating script engine: %s %s (%s %s)", engineFactory.getEngineName(), engineFactory.getEngineVersion(), engineFactory.getLanguageName(), engineFactory.getLanguageVersion()));
            List<String> extensions = engineFactory.getExtensions();
            if (extensions.contains(FileUtility.getFileExtension(scriptFile))) {
                scriptEngineFactory = engineFactory;
                break;
            }
            if (!engineFactory.getLanguageName().equalsIgnoreCase("JavaScript")) continue;
            javaScriptEngineFactory = engineFactory;
        }
        if (scriptEngineFactory == null) {
            scriptEngineFactory = javaScriptEngineFactory;
        }
        if (scriptEngineFactory == null) {
            throw new SchemaCrawlerException("Script engine not found");
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, String.format("Using script engine\n%s %s (%s %s)\nScript engine names: %s\nSupported file extensions: %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), ObjectToString.toString(scriptEngineFactory.getNames()), ObjectToString.toString(scriptEngineFactory.getExtensions())));
        }
        ScriptEngine scriptEngine = scriptEngineFactory.getScriptEngine();
        PrintWriter writer = this.outputOptions.openOutputWriter();
        scriptEngine.getContext().setWriter(writer);
        scriptEngine.put("database", database);
        scriptEngine.put("connection", connection);
        scriptEngine.eval(reader);
        this.outputOptions.closeOutputWriter(writer);
    }
}

