/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import com.typesafe.config.Config;
import net.shrine.adapter.Adapter;
import net.shrine.adapter.AdapterComponents;
import net.shrine.adapter.AdapterMap;
import net.shrine.adapter.DeleteQueryAdapter;
import net.shrine.adapter.FlagQueryAdapter;
import net.shrine.adapter.Obfuscator;
import net.shrine.adapter.Obfuscator$;
import net.shrine.adapter.ReadInstanceResultsAdapter;
import net.shrine.adapter.ReadPreviousQueriesAdapter;
import net.shrine.adapter.ReadQueryDefinitionAdapter;
import net.shrine.adapter.ReadQueryResultAdapter;
import net.shrine.adapter.ReadTranslatedQueryDefinitionAdapter;
import net.shrine.adapter.RenameQueryAdapter;
import net.shrine.adapter.RunQueryAdapter;
import net.shrine.adapter.UnFlagQueryAdapter;
import net.shrine.adapter.dao.AdapterDao;
import net.shrine.adapter.dao.squeryl.SquerylAdapterDao;
import net.shrine.adapter.dao.squeryl.SquerylI2b2AdminDao;
import net.shrine.adapter.dao.squeryl.tables.Tables;
import net.shrine.adapter.mappings.AdapterMappings;
import net.shrine.adapter.mappings.ClasspathFormatDetectingAdapterMappingsSource;
import net.shrine.adapter.service.AdapterService;
import net.shrine.adapter.service.I2b2AdminService;
import net.shrine.adapter.translators.ExpressionTranslator;
import net.shrine.adapter.translators.ExpressionTranslator$;
import net.shrine.adapter.translators.QueryDefinitionTranslator;
import net.shrine.client.EndpointConfig;
import net.shrine.client.EndpointConfig$;
import net.shrine.client.Poster;
import net.shrine.client.Poster$;
import net.shrine.config.DurationConfigParser$;
import net.shrine.config.package$;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.dao.squeryl.SquerylInitializer;
import net.shrine.log.Log$;
import net.shrine.protocol.HiveCredentials;
import net.shrine.protocol.RequestType;
import net.shrine.protocol.RequestType$;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.XmlNodeName;
import net.shrine.protocol.cryptoxml.SignerVerifierAdapter;
import net.shrine.protocol.cryptoxml.Verifier;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;

public final class AdapterComponents$
implements Serializable {
    public static final AdapterComponents$ MODULE$;

    static {
        new AdapterComponents$();
    }

    public AdapterComponents apply(Config adapterConfig, BouncyKeyStoreCollection certCollection, SquerylInitializer squerylInitializer, Set<ResultOutputType> breakdownTypes, HiveCredentials crcHiveCredentials, SignerVerifierAdapter signerVerifier, Poster pmPoster, XmlNodeName nodeId) {
        EndpointConfig crcEndpoint = (EndpointConfig)package$.MODULE$.ConfigExtensions(adapterConfig).getConfigured("crcEndpoint", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final EndpointConfig apply(Config x$1) {
                return EndpointConfig$.MODULE$.apply(x$1);
            }
        });
        Poster crcPoster = Poster$.MODULE$.apply(certCollection, crcEndpoint);
        Tables squerylAdapterTables = new Tables();
        SquerylAdapterDao adapterDao = new SquerylAdapterDao(squerylInitializer, squerylAdapterTables, breakdownTypes);
        SquerylI2b2AdminDao i2b2AdminDao = new SquerylI2b2AdminDao(crcHiveCredentials.projectId(), squerylInitializer, squerylAdapterTables);
        String adapterMappingsFile = adapterConfig.getString("adapterMappingsFileName");
        ClasspathFormatDetectingAdapterMappingsSource adapterMappingsSource = new ClasspathFormatDetectingAdapterMappingsSource(adapterMappingsFile);
        AdapterMappings adapterMappings = (AdapterMappings)adapterMappingsSource.load(adapterMappingsFile).get();
        ExpressionTranslator expressionTranslator = ExpressionTranslator$.MODULE$.apply(adapterMappings);
        QueryDefinitionTranslator queryDefinitionTranslator = new QueryDefinitionTranslator(expressionTranslator);
        boolean doObfuscation = adapterConfig.getBoolean("setSizeObfuscation");
        boolean collectAdapterAudit = adapterConfig.getBoolean("audit.collectAdapterAudit");
        Duration queuedQueryTimeToLive = (Duration)package$.MODULE$.ConfigExtensions(adapterConfig).get("queuedQueryTimeToLive", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$2) {
                return Duration$.MODULE$.apply(x$2);
            }
        });
        Seq countsAndMilliseconds = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(adapterConfig.getConfig("botDefense").getConfigList("countsAndMilliseconds")).asScala();
        Seq botCountTimeThresholds = (Seq)countsAndMilliseconds.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, FiniteDuration> apply(Config pairConfig) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)pairConfig.getLong("count")), (Object)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(pairConfig.getLong("milliseconds"))).milliseconds());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Obfuscator obfuscator = (Obfuscator)package$.MODULE$.ConfigExtensions(adapterConfig).getConfigured("obfuscation", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Obfuscator apply(Config x$3) {
                return Obfuscator$.MODULE$.apply(x$3);
            }
        });
        Log$.MODULE$.info((Function0)new Serializable(obfuscator){
            public static final long serialVersionUID = 0L;
            private final Obfuscator obfuscator$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"obfuscator is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.obfuscator$1}));
            }
            {
                this.obfuscator$1 = obfuscator$1;
            }
        });
        RunQueryAdapter runQueryAdapter = new RunQueryAdapter(crcPoster, adapterDao, crcHiveCredentials, queryDefinitionTranslator, doObfuscation, adapterConfig.getBoolean("immediatelyRunIncomingQueries"), breakdownTypes, collectAdapterAudit, (Seq<Tuple2<Object, Duration>>)botCountTimeThresholds, obfuscator, (Duration)package$.MODULE$.ConfigExtensions(adapterConfig).get("crcRunQueryTimeLimit", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$4) {
                return Duration$.MODULE$.apply(x$4);
            }
        }), certCollection);
        ReadInstanceResultsAdapter readInstanceResultsAdapter = new ReadInstanceResultsAdapter(crcPoster, crcHiveCredentials, adapterDao, doObfuscation, breakdownTypes, collectAdapterAudit, obfuscator, queuedQueryTimeToLive);
        ReadQueryResultAdapter readQueryResultAdapter = new ReadQueryResultAdapter(crcPoster, crcHiveCredentials, adapterDao, doObfuscation, breakdownTypes, collectAdapterAudit, obfuscator, queuedQueryTimeToLive);
        ReadPreviousQueriesAdapter readPreviousQueriesAdapter = new ReadPreviousQueriesAdapter(adapterDao);
        DeleteQueryAdapter deleteQueryAdapter = new DeleteQueryAdapter(adapterDao);
        RenameQueryAdapter renameQueryAdapter = new RenameQueryAdapter(adapterDao);
        ReadQueryDefinitionAdapter readQueryDefinitionAdapter = new ReadQueryDefinitionAdapter(adapterDao);
        ReadTranslatedQueryDefinitionAdapter readTranslatedQueryDefinitionAdapter = new ReadTranslatedQueryDefinitionAdapter(nodeId, queryDefinitionTranslator);
        FlagQueryAdapter flagQueryAdapter = new FlagQueryAdapter(adapterDao);
        UnFlagQueryAdapter unFlagQueryAdapter = new UnFlagQueryAdapter(adapterDao);
        AdapterMap adapterMap = new AdapterMap((Map<RequestType, Adapter>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.QueryDefinitionRequest()), (Object)runQueryAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.GetRequestXml()), (Object)readQueryDefinitionAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.UserRequest()), (Object)readPreviousQueriesAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.InstanceRequest()), (Object)readInstanceResultsAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.MasterDeleteRequest()), (Object)deleteQueryAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.MasterRenameRequest()), (Object)renameQueryAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.GetQueryResult()), (Object)readQueryResultAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.ReadTranslatedQueryDefinitionRequest()), (Object)readTranslatedQueryDefinitionAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.FlagQueryRequest()), (Object)flagQueryAdapter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RequestType$.MODULE$.UnFlagQueryRequest()), (Object)unFlagQueryAdapter)}))));
        return new AdapterComponents(new AdapterService(nodeId, (Verifier)signerVerifier, (Duration)package$.MODULE$.ConfigExtensions(adapterConfig).getConfigured("maxSignatureAge", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FiniteDuration apply(Config x$5) {
                return DurationConfigParser$.MODULE$.apply(x$5);
            }
        }), adapterMap), new I2b2AdminService(adapterDao, i2b2AdminDao, pmPoster, runQueryAdapter), adapterDao, adapterMappings, adapterMappingsSource.lastModified());
    }

    public AdapterComponents apply(AdapterService adapterService, I2b2AdminService i2b2AdminService, AdapterDao adapterDao, AdapterMappings adapterMappings, long lastModified) {
        return new AdapterComponents(adapterService, i2b2AdminService, adapterDao, adapterMappings, lastModified);
    }

    public Option<Tuple5<AdapterService, I2b2AdminService, AdapterDao, AdapterMappings, Object>> unapply(AdapterComponents x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.adapterService(), (Object)x$0.i2b2AdminService(), (Object)x$0.adapterDao(), (Object)x$0.adapterMappings(), (Object)BoxesRunTime.boxToLong((long)x$0.lastModified())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AdapterComponents$() {
        MODULE$ = this;
    }
}

