/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import java.util.Random;
import org.apache.log4j.Logger;

public abstract class GaussianObfuscator {
    private static final double STD_DEV = 1.33;
    private static final double MEAN = 0.0;
    private static final Random generator = new Random();
    private static final Logger log = Logger.getLogger(GaussianObfuscator.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final String SAMPLE_SMALLER_THAN_TEN = "Sample sizes smaller than 10 will not be returned in order to prevent inadvertent identification of the sampled patients.";
    public static final int RANGE = 3;

    private GaussianObfuscator() {
    }

    public static double obfuscate(double x) {
        return x + (double)Math.round(GaussianObfuscator.gaussian(0.0, 1.33));
    }

    public static int obfuscate(QueryResultInstanceType result, int obfuscationAmount) {
        if (result.getQueryResultType().getName().equals("PATIENT_COUNT_XML")) {
            if (result.getSetSize() <= 10) {
                result.setSetSize(-1);
                result.setDescription(SAMPLE_SMALLER_THAN_TEN);
            } else {
                int originalSetSize = result.getSetSize();
                if (DEBUG) {
                    log.debug((Object)("Obfuscated results: original count: " + originalSetSize + " obfuscated: " + obfuscationAmount));
                }
                result.setSetSize(originalSetSize + obfuscationAmount);
                return obfuscationAmount;
            }
        }
        return 0;
    }

    public static int obfuscate(QueryResultInstanceType result) {
        return GaussianObfuscator.obfuscate(result, GaussianObfuscator.determineObfuscationAmount(result.getSetSize()));
    }

    public static int determineObfuscationAmount(long x) {
        return (int)Math.round(GaussianObfuscator.gaussian(0.0, 1.33));
    }

    public static long determineObfuscatedSetSize(long setSize, int obfuscationAmount) {
        if (setSize <= 10L) {
            return -1L;
        }
        return setSize + (long)obfuscationAmount;
    }

    public static double gaussian(double mean, double stddev) {
        double v = mean + stddev * GaussianObfuscator.gaussian();
        v = GaussianObfuscator.limitRange(v);
        return v;
    }

    private static double limitRange(double v) {
        v = v < -3.0 ? -3.0 : v;
        v = v > 3.0 ? 3.0 : v;
        return v;
    }

    private static double gaussian() {
        return generator.nextGaussian();
    }
}

