/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.shrine.adapter.AdapterLockoutException;
import net.shrine.adapter.CrcAdapter;
import net.shrine.adapter.Obfuscator$;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.adapter.dao.IDPair;
import net.shrine.adapter.dao.MasterTuple;
import net.shrine.adapter.dao.RequestResponseData;
import net.shrine.adapter.dao.ResultTuple;
import net.shrine.adapter.dao.UserAndMaster;
import net.shrine.adapter.translators.DefaultConceptTranslator;
import net.shrine.config.I2B2HiveCredentials;
import net.shrine.config.ShrineConfig;
import net.shrine.protocol.BroadcastMessage;
import net.shrine.protocol.QueryResult;
import net.shrine.protocol.RunQueryRequest;
import net.shrine.protocol.RunQueryResponse;
import net.shrine.protocol.RunQueryResponse$;
import net.shrine.util.XmlUtil$;
import org.spin.tools.crypto.signature.Identity;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.NodeSeq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001%\u0011qBU;o#V,'/_!eCB$XM\u001d\u0006\u0003\u0007\u0011\tq!\u00193baR,'O\u0003\u0002\u0006\r\u000511\u000f\u001b:j]\u0016T\u0011aB\u0001\u0004]\u0016$8\u0001A\n\u0004\u0001)9\u0002\u0003B\u0006\r\u001dQi\u0011AA\u0005\u0003\u001b\t\u0011!b\u0011:d\u0003\u0012\f\u0007\u000f^3s!\ty!#D\u0001\u0011\u0015\t\tB!\u0001\u0005qe>$xnY8m\u0013\t\u0019\u0002CA\bSk:\fV/\u001a:z%\u0016\fX/Z:u!\tyQ#\u0003\u0002\u0017!\t\u0001\"+\u001e8Rk\u0016\u0014\u0018PU3ta>t7/\u001a\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0015 \u0003\u0019\u0019'oY+sYV\t\u0001\u0005\u0005\u0002\"I9\u0011\u0001DI\u0005\u0003Ge\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111%\u0007\u0005\tQ\u0001\u0011\t\u0011)A\u0005A\u000591M]2Ve2\u0004\u0003\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011K\u0016\u0002\u0007\u0011\fw.F\u0001-!\tis&D\u0001/\u0015\tQ#!\u0003\u00021]\tQ\u0011\tZ1qi\u0016\u0014H)Q(\t\u0011I\u0002!\u0011!Q\u0001\n1\nA\u0001Z1pA!AA\u0007\u0001BC\u0002\u0013ES'A\biSZ,7I]3eK:$\u0018.\u00197t+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003\u0019\u0019wN\u001c4jO&\u00111\b\u000f\u0002\u0014\u0013J\u0012%\u0007S5wK\u000e\u0013X\rZ3oi&\fGn\u001d\u0005\t{\u0001\u0011\t\u0011)A\u0005m\u0005\u0001\u0002.\u001b<f\u0007J,G-\u001a8uS\u0006d7\u000f\t\u0005\t\u007f\u0001\u0011)\u0019!C\u0005\u0001\u0006\t2m\u001c8dKB$HK]1og2\fGo\u001c:\u0016\u0003\u0005\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0002\u0002\u0017Q\u0014\u0018M\\:mCR|'o]\u0005\u0003\r\u000e\u0013\u0001\u0004R3gCVdGoQ8oG\u0016\u0004H\u000f\u0016:b]Nd\u0017\r^8s\u0011!A\u0005A!A!\u0002\u0013\t\u0015AE2p]\u000e,\u0007\u000f\u001e+sC:\u001cH.\u0019;pe\u0002B\u0001\"\u000f\u0001\u0003\u0006\u0004%IAS\u000b\u0002\u0017B\u0011q\u0007T\u0005\u0003\u001bb\u0012Ab\u00155sS:,7i\u001c8gS\u001eD\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IaS\u0001\bG>tg-[4!\u0011!\t\u0006A!b\u0001\n\u0013\u0011\u0016!\u00043p\u001f\n4Wo]2bi&|g.F\u0001T!\tAB+\u0003\u0002V3\t9!i\\8mK\u0006t\u0007\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B*\u0002\u001d\u0011|wJ\u00194vg\u000e\fG/[8oA!)\u0011\f\u0001C\u00015\u00061A(\u001b8jiz\"ra\u0017/^=~\u0003\u0017\r\u0005\u0002\f\u0001!)a\u0004\u0017a\u0001A!)!\u0006\u0017a\u0001Y!)A\u0007\u0017a\u0001m!)q\b\u0017a\u0001\u0003\")\u0011\b\u0017a\u0001\u0017\")\u0011\u000b\u0017a\u0001'\"91\r\u0001b\u0001\n\u0013!\u0017aB2p]R,\u0007\u0010^\u000b\u0002KB\u0011a-\\\u0007\u0002O*\u0011\u0001.[\u0001\u0005E&tGM\u0003\u0002kW\u0006\u0019\u00010\u001c7\u000b\u00031\fQA[1wCbL!A\\4\u0003\u0017)\u000b\u0005LQ\"p]R,\u0007\u0010\u001e\u0005\u0007a\u0002\u0001\u000b\u0011B3\u0002\u0011\r|g\u000e^3yi\u0002BQA\u001d\u0001\u0005\u0012M\f1\u0003]1sg\u0016\u001c\u0006N]5oKJ+7\u000f]8og\u0016$\"\u0001\u0006;\t\u000bU\f\b\u0019\u0001<\u0002\u000f9|G-Z*fcB\u0011q/_\u0007\u0002q*\u0011!.G\u0005\u0003ub\u0014qAT8eKN+\u0017\u000fC\u0003}\u0001\u0011EQ0A\fue\u0006t7\u000f\\1uK2{7-\u00197U_:+Go^8sWR\u0011AC \u0005\u0006\u007fn\u0004\r\u0001F\u0001\te\u0016\u001c\bo\u001c8tK\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0011a\t;sC:\u001cH.\u0019;f\u0019>\u001c\u0017\r\u001c*fgVdG/\u00133t)>tU\r^<pe.LEm\u001d\u000b\b)\u0005\u001d\u00111BA\u0007\u0011\u001d\tI!!\u0001A\u0002Q\t1\u0004]1si&\fG\u000e\\=Ue\u0006t7\u000f\\1uK\u0012\u0014Vm\u001d9p]N,\u0007BB@\u0002\u0002\u0001\u0007A\u0003\u0003\u0005\u0002\u0010\u0005\u0005\u0001\u0019AA\t\u0003%\u0011Xm];mi&#7\u000f\u0005\u0004\u0002\u0014\u0005\r\u0012\u0011\u0006\b\u0005\u0003+\tyB\u0004\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tY\u0002C\u0001\u0007yI|w\u000e\u001e \n\u0003iI1!!\t\u001a\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\t\u00191+Z9\u000b\u0007\u0005\u0005\u0012\u0004E\u0002\u0019\u0003WI1!!\f\u001a\u0005\u0011auN\\4\t\u000f\u0005E\u0002\u0001\"\u0003\u00024\u0005iBO]1og2\fG/\u001a'pG\u0006d\u0017\nZ:U_:+Go^8sW&#7\u000fF\u0005\u0015\u0003k\t9$a\u000f\u0002@!1q0a\fA\u0002QA\u0001\"!\u000f\u00020\u0001\u0007\u0011\u0011F\u0001\t[\u0006\u001cH/\u001a:JI\"A\u0011QHA\u0018\u0001\u0004\tI#\u0001\u0006j]N$\u0018M\\2f\u0013\u0012D\u0001\"a\u0004\u00020\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003\u0007\u0002A\u0011BA#\u0003a)h.\\1sg\"\fG.U;fef$UMZ5oSRLwN\u001c\u000b\u0005\u0003\u000f\nY\u0007\u0005\u0003\u0002J\u0005\u001dTBAA&\u0015\u0011\ti%a\u0014\u0002\u000bE,XM]=\u000b\t\u0005E\u00131K\u0001\ng\u0016$h-\u001b8eKJTA!!\u0016\u0002X\u00051A-\u0019;bm>TA!!\u0017\u0002\\\u0005\u00191M]2\u000b\t\u0005u\u0013qL\u0001\u0005SJ\u0012'G\u0003\u0003\u0002b\u0005\r\u0014a\u00025beZ\f'\u000f\u001a\u0006\u0003\u0003K\n1!\u001a3v\u0013\u0011\tI'a\u0013\u0003'E+XM]=EK\u001aLg.\u001b;j_:$\u0016\u0010]3\t\u000f\u00055\u0014\u0011\ta\u0001A\u0005y\u0011/^3ss\u0012+g-\u001b8ji&|g\u000eC\u0004\u0002r\u0001!I!a\u001d\u0002-5\f'o\u001d5bYF+XM]=EK\u001aLg.\u001b;j_:$2\u0001IA;\u0011!\t9(a\u001cA\u0002\u0005\u001d\u0013\u0001C9vKJLH)\u001a4\t\u0011\u0005m\u0004\u0001\"\u0001\u0003\u0003{\n\u0001\u0004\u001e:b]Nd\u0017\r^3Rk\u0016\u0014\u0018\u0010R3gS:LG/[8o)\r\u0001\u0013q\u0010\u0005\b\u0003[\nI\b1\u0001!\u0011\u001d\t\u0019\t\u0001C\t\u0003\u000b\u000bq\u0003\u001e:b]Nd\u0017\r^3OKR<xN]6U_2{7-\u00197\u0015\u00079\t9\tC\u0004\u0002\n\u0006\u0005\u0005\u0019\u0001\b\u0002\u000fI,\u0017/^3ti\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015aD5og\u0016\u0014HOU3tk2$\u0018\nZ:\u0015\u0011\u0005E\u0015qSAM\u0003s\u00032\u0001GAJ\u0013\r\t)*\u0007\u0002\u0005+:LG\u000f\u0003\u0004\u0000\u0003\u0017\u0003\r\u0001\u0006\u0005\t\u00037\u000bY\t1\u0001\u0002\u001e\u0006A\u0011\u000eZ3oi&$\u0018\u0010\u0005\u0003\u0002 \u0006UVBAAQ\u0015\u0011\t\u0019+!*\u0002\u0013MLwM\\1ukJ,'\u0002BAT\u0003S\u000baa\u0019:zaR|'\u0002BAV\u0003[\u000bQ\u0001^8pYNTA!a,\u00022\u0006!1\u000f]5o\u0015\t\t\u0019,A\u0002pe\u001eLA!a.\u0002\"\nA\u0011\nZ3oi&$\u0018\u0010\u0003\u0005\u0002<\u0006-\u0005\u0019AA_\u0003\u001diWm]:bO\u0016\u00042aDA`\u0013\r\t\t\r\u0005\u0002\u0011\u0005J|\u0017\rZ2bgRlUm]:bO\u0016Dq!!2\u0001\t\u0013\t9-\u0001\tde\u0016\fG/Z%e\u001b\u0006\u0004\b/\u001b8hgRA\u0011\u0011SAe\u0003\u0017\fi\r\u0003\u0005\u0002\u001c\u0006\r\u0007\u0019AAO\u0011!\tY,a1A\u0002\u0005u\u0006BB@\u0002D\u0002\u0007A\u0003C\u0004\u0002R\u0002!\t\"a5\u0002#=\u0014g-^:dCR,'+Z:q_:\u001cX\rF\u0002\u0015\u0003+Daa`Ah\u0001\u0004!\u0002bBAm\u0001\u0011%\u00111\\\u0001\fSNdunY6fI>+H\u000fF\u0002T\u0003;D\u0001\"a'\u0002X\u0002\u0007\u0011Q\u0014\u0005\b\u0003C\u0004A\u0011KAr\u00039\u0001(o\\2fgN\u0014V-];fgR$R\u0001FAs\u0003OD\u0001\"a'\u0002`\u0002\u0007\u0011Q\u0014\u0005\t\u0003w\u000by\u000e1\u0001\u0002>\u0002")
public class RunQueryAdapter
extends CrcAdapter<RunQueryRequest, RunQueryResponse>
implements ScalaObject {
    private final String crcUrl;
    private final AdapterDAO dao;
    private final I2B2HiveCredentials hiveCredentials;
    private final DefaultConceptTranslator conceptTranslator;
    private final ShrineConfig config;
    private final boolean doObfuscation;
    private final JAXBContext context;

    @Override
    public String crcUrl() {
        return this.crcUrl;
    }

    @Override
    public AdapterDAO dao() {
        return this.dao;
    }

    @Override
    public I2B2HiveCredentials hiveCredentials() {
        return this.hiveCredentials;
    }

    private DefaultConceptTranslator conceptTranslator() {
        return this.conceptTranslator;
    }

    private ShrineConfig config() {
        return this.config;
    }

    private boolean doObfuscation() {
        return this.doObfuscation;
    }

    private JAXBContext context() {
        return this.context;
    }

    public RunQueryResponse parseShrineResponse(NodeSeq nodeSeq) {
        return RunQueryResponse$.MODULE$.fromI2b2(nodeSeq);
    }

    @Override
    public RunQueryResponse translateLocalToNetwork(RunQueryResponse response) {
        return response;
    }

    private RunQueryResponse translateLocalResultIdsToNetworkIds(RunQueryResponse partiallyTranslatedResponse, RunQueryResponse response, Seq<Object> resultIds$1) {
        return partiallyTranslatedResponse.withResults((Seq)((TraversableLike)response.results().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, resultIds$1){
            public static final long serialVersionUID;
            private final Seq resultIds$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final QueryResult apply(Tuple2<QueryResult, Object> tuple2) {
                Tuple2<QueryResult, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    return ((QueryResult)tuple22._1()).withId(BoxesRunTime.unboxToLong((Object)this.resultIds$1.apply(BoxesRunTime.unboxToInt((Object)tuple22._2()))));
                }
                throw new MatchError(tuple22);
            }
            {
                this.resultIds$1 = seq;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private RunQueryResponse translateLocalIdsToNetworkIds(RunQueryResponse response, long masterId, long instanceId, Seq<Object> resultIds) {
        RunQueryResponse partiallyTranslatedResponse = response.withId(masterId).withInstanceId(instanceId);
        return this.translateLocalResultIdsToNetworkIds(partiallyTranslatedResponse, response, resultIds);
    }

    private QueryDefinitionType unmarshalQueryDefinition(String queryDefinition) {
        Unmarshaller unmarshaller = this.context().createUnmarshaller();
        return (QueryDefinitionType)unmarshaller.unmarshal((Reader)new StringReader(queryDefinition));
    }

    private String marshalQueryDefinition(QueryDefinitionType queryDef) {
        Marshaller marshaller = this.context().createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)queryDef, (Writer)stringWriter);
        String newQueryDefString = stringWriter.toString();
        return newQueryDefString;
    }

    public String translateQueryDefinition(String queryDefinition) {
        QueryDefinitionType queryDef = this.unmarshalQueryDefinition(queryDefinition);
        this.conceptTranslator().translateQueryDefinition(queryDef);
        return XmlUtil$.MODULE$.stripNamespace(this.marshalQueryDefinition(queryDef));
    }

    @Override
    public RunQueryRequest translateNetworkToLocal(RunQueryRequest request) {
        return request.withQueryDefinition(this.translateQueryDefinition(request.queryDefinitionXml()));
    }

    private void insertResultIds(RunQueryResponse response$1, Identity identity$1, BroadcastMessage message$1) {
        ((IterableLike)response$1.results().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, response$1, identity$1, message$1){
            public static final long serialVersionUID;
            private final RunQueryAdapter $outer;
            private final RunQueryResponse response$1;
            private final Identity identity$1;
            private final BroadcastMessage message$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<QueryResult, Object> tuple2) {
                Tuple2<QueryResult, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    int n;
                    int i = n = BoxesRunTime.unboxToInt((Object)tuple22._2());
                    QueryResult result = (QueryResult)this.response$1.results().apply(i);
                    this.$outer.dao().insertRequestResponseData(new RequestResponseData(this.identity$1.getDomain(), this.identity$1.getUsername(), BoxesRunTime.unboxToLong((Object)this.message$1.masterId().get()), BoxesRunTime.unboxToLong((Object)this.message$1.instanceId().get()), BoxesRunTime.unboxToLong((Object)((SeqLike)this.message$1.resultIds().get()).apply(i)), result.statusType(), (int)result.setSize(), 0L, "", this.response$1.toI2b2().toString()));
                    this.$outer.dao().insertResultTuple(new ResultTuple(IDPair.of(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)((SeqLike)this.message$1.resultIds().get()).apply(i))), ((Object)BoxesRunTime.boxToLong((long)result.resultId())).toString())));
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.response$1 = runQueryResponse;
                this.identity$1 = identity;
                this.message$1 = broadcastMessage;
            }
        });
    }

    private void createIdMappings(Identity identity, BroadcastMessage message, RunQueryResponse response) {
        this.dao().insertUserAndMasterIDMapping(new UserAndMaster(identity.getDomain(), identity.getUsername(), Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)message.masterId().get())), response.queryName(), response.createDate().toGregorianCalendar().getTime()));
        this.dao().insertMaster(new MasterTuple(IDPair.of(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)message.masterId().get())), ((Object)BoxesRunTime.boxToLong((long)response.queryId())).toString()), ((RunQueryRequest)message.request()).queryDefinitionXml()));
        this.dao().insertInstanceIDPair(IDPair.of(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)message.instanceId().get())), ((Object)BoxesRunTime.boxToLong((long)response.queryInstanceId())).toString()));
        this.insertResultIds(response, identity, message);
    }

    public RunQueryResponse obfuscateResponse(RunQueryResponse response) {
        return this.doObfuscation() ? response.withResults(Obfuscator$.MODULE$.obfuscate((Seq<QueryResult>)response.results(), this.dao())) : response;
    }

    private boolean isLockedOut(Identity identity) {
        return this.config().getAdapterLockoutAttemptsThreshold() == 0 ? false : this.dao().isUserLockedOut(identity, Predef$.MODULE$.int2Integer(this.config().getAdapterLockoutAttemptsThreshold()));
    }

    public RunQueryResponse processRequest(Identity identity, BroadcastMessage message) {
        if (this.isLockedOut(identity)) {
            throw new AdapterLockoutException(identity);
        }
        RunQueryResponse response = (RunQueryResponse)super.processRequest(identity, message);
        this.createIdMappings(identity, message, response);
        response = this.translateLocalIdsToNetworkIds(response, BoxesRunTime.unboxToLong((Object)message.masterId().get()), BoxesRunTime.unboxToLong((Object)message.instanceId().get()), (Seq<Object>)((Seq)message.resultIds().get()));
        return this.obfuscateResponse(response);
    }

    public RunQueryAdapter(String crcUrl, AdapterDAO dao, I2B2HiveCredentials hiveCredentials, DefaultConceptTranslator conceptTranslator, ShrineConfig config, boolean doObfuscation) {
        this.crcUrl = crcUrl;
        this.dao = dao;
        this.hiveCredentials = hiveCredentials;
        this.conceptTranslator = conceptTranslator;
        this.config = config;
        this.doObfuscation = doObfuscation;
        super(crcUrl, dao, hiveCredentials);
        this.context = JAXBContext.newInstance((Class[])new Class[]{QueryDefinitionType.class});
    }
}

