/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.dao;

public final class IDPair {
    private Long networkID;
    private String localID;

    private IDPair() {
    }

    private IDPair(Long networkID, String localID) {
        this.networkID = networkID;
        this.localID = localID;
    }

    public static IDPair of(Long networkID, String localID) {
        return new IDPair(networkID, localID);
    }

    public static IDPair networkOnly(Long networkID) {
        return new IDPair(networkID, null);
    }

    public static IDPair localOnly(String localID) {
        return new IDPair(null, localID);
    }

    public Long getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(Long networkID) {
        this.networkID = networkID;
    }

    public String getLocalID() {
        return this.localID;
    }

    public void setLocalID(String localID) {
        this.localID = localID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localID == null ? 0 : this.localID.hashCode());
        result = 31 * result + (this.networkID == null ? 0 : this.networkID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IDPair other = (IDPair)obj;
        if (this.localID == null ? other.localID != null : !this.localID.equals(other.localID)) {
            return false;
        }
        return !(this.networkID == null ? other.networkID != null : !this.networkID.equals(other.networkID));
    }

    public String toString() {
        return "IDPair [networkID=" + this.networkID + ", localID=" + this.localID + "]";
    }

    public static IDPair empty() {
        return new IDPair();
    }
}

