/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.dao;

import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryMasterType;
import java.util.Date;
import org.spin.tools.NetworkTime;

public final class UserAndMaster {
    private String domainName;
    private String userName;
    private Long networkMasterID;
    private String masterName;
    private Date masterCreateDate;

    private UserAndMaster() {
        this(null, null);
    }

    public UserAndMaster(String domainName, String userName) {
        this(domainName, userName, null, null, null);
    }

    public UserAndMaster(String domainName, String userName, Long networkMasterID, String masterName, Date masterCreateDate) {
        this.domainName = domainName;
        this.userName = userName;
        this.networkMasterID = networkMasterID;
        this.masterName = masterName;
        this.masterCreateDate = masterCreateDate;
    }

    public QueryMasterType toQueryMasterType() {
        QueryMasterType result = new QueryMasterType();
        result.setGroupId(this.domainName);
        result.setUserId(this.userName);
        result.setQueryMasterId(String.valueOf(this.networkMasterID));
        result.setName(this.masterName);
        result.setCreateDate(NetworkTime.makeXMLGregorianCalendar((Date)this.masterCreateDate));
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domainName == null ? 0 : this.domainName.hashCode());
        result = 31 * result + (this.masterCreateDate == null ? 0 : this.masterCreateDate.hashCode());
        result = 31 * result + (this.masterName == null ? 0 : this.masterName.hashCode());
        result = 31 * result + (this.networkMasterID == null ? 0 : this.networkMasterID.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAndMaster other = (UserAndMaster)obj;
        if (this.domainName == null ? other.domainName != null : !this.domainName.equals(other.domainName)) {
            return false;
        }
        if (this.masterCreateDate == null ? other.masterCreateDate != null : !this.masterCreateDate.equals(other.masterCreateDate)) {
            return false;
        }
        if (this.masterName == null ? other.masterName != null : !this.masterName.equals(other.masterName)) {
            return false;
        }
        if (this.networkMasterID == null ? other.networkMasterID != null : !this.networkMasterID.equals(other.networkMasterID)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String toString() {
        return "UserAndMaster [domainName=" + this.domainName + ", masterCreateDate=" + this.masterCreateDate + ", masterName=" + this.masterName + ", networkMasterID=" + this.networkMasterID + ", userName=" + this.userName + "]";
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Long getNetworkMasterID() {
        return this.networkMasterID;
    }

    public void setNetworkMasterID(Long networkMasterID) {
        this.networkMasterID = networkMasterID;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public Date getMasterCreateDate() {
        return this.masterCreateDate;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setMasterCreateDate(Date masterCreateDate) {
        this.masterCreateDate = masterCreateDate;
    }
}

