/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.translators;

import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryDefinitionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import net.shrine.adapter.AdapterMappingException;
import net.shrine.config.AdapterMappings;
import net.shrine.serializers.ShrineJAXBUtils;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;

public class DefaultConceptTranslator {
    public static final Logger log = Logger.getLogger(DefaultConceptTranslator.class);
    public static final boolean DEBUG = log.isDebugEnabled();
    protected final AdapterMappings mappings;

    public DefaultConceptTranslator() throws ConfigException {
        this.mappings = AdapterMappings.getDefaultInstance();
    }

    public DefaultConceptTranslator(AdapterMappings mappings) {
        this.mappings = mappings;
    }

    public DefaultConceptTranslator(Map<String, List<String>> adaptorMappings) {
        this.mappings = new AdapterMappings();
        for (String s : adaptorMappings.keySet()) {
            for (String s2 : adaptorMappings.get(s)) {
                this.mappings.addMapping(s, s2);
            }
        }
    }

    public void translateQueryDefinition(QueryDefinitionType queryDef) throws SerializationException, AdapterMappingException {
        List panels = queryDef.getPanel();
        for (PanelType panel : panels) {
            this.translatePanel(panel);
        }
    }

    protected void translatePanel(PanelType panel) throws SerializationException, AdapterMappingException {
        List items = panel.getItem();
        ArrayList translatedItems = Util.makeArrayList();
        for (ItemType item : items) {
            List locals = this.mappings.getMappings(item.getItemKey());
            for (String local : locals) {
                try {
                    ItemType translatedItem = (ItemType)ShrineJAXBUtils.copy((Object)item);
                    translatedItem.setItemKey(local);
                    translatedItems.add(translatedItem);
                }
                catch (JAXBException jaxbe) {
                    String msg = "Translation error- failed to copy construct :" + String.valueOf(item);
                    log.error((Object)msg, (Throwable)jaxbe);
                    throw new SerializationException(msg, (Exception)((Object)jaxbe));
                }
            }
        }
        if (translatedItems.isEmpty()) {
            throw new AdapterMappingException(String.format("Panel %d contains no mappable terms", panel.getPanelNumber()));
        }
        items.clear();
        items.addAll(translatedItems);
    }
}

