/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.translators;

import edu.harvard.i2b2.crc.datavo.setfinder.query.ItemType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.PanelType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import net.shrine.adapter.AdapterMappingException;
import net.shrine.adapter.translators.DefaultConceptTranslator;
import net.shrine.config.AdapterMappings;
import net.shrine.serializers.ShrineJAXBUtils;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.config.ConfigException;

public final class SimpleConceptTranslator
extends DefaultConceptTranslator {
    public SimpleConceptTranslator() throws ConfigException {
    }

    public SimpleConceptTranslator(AdapterMappings mappings) {
        super(mappings);
    }

    public SimpleConceptTranslator(Map<String, List<String>> adaptorMappings) {
        super(adaptorMappings);
    }

    @Override
    protected void translatePanel(PanelType panel) throws SerializationException, AdapterMappingException {
        List items = panel.getItem();
        ArrayList<ItemType> translatedItems = new ArrayList<ItemType>();
        for (ItemType item : items) {
            List locals = this.mappings.getMappings(item.getItemKey());
            if (locals.isEmpty()) {
                translatedItems.add(item);
            }
            for (String local : locals) {
                try {
                    ItemType translatedItem = (ItemType)ShrineJAXBUtils.copy((Object)item);
                    translatedItem.setItemKey(local);
                    translatedItems.add(translatedItem);
                }
                catch (JAXBException jaxbe) {
                    String msg = "Translation error- failed to copy construct :" + String.valueOf(item);
                    log.error((Object)msg, (Throwable)jaxbe);
                    throw new SerializationException(msg, (Exception)((Object)jaxbe));
                }
            }
        }
        items.clear();
        items.addAll(translatedItems);
    }
}

