(function () {
    angular.module('shrine.steward')
        .directive('inputvalidator', InputValidationDirective);

    function InputValidationDirective() {
        var blackListRegex = /(<script|<\/script>|\^|!|`|~)/;
        return {
            // element must have ng-model attribute
            // or $validators does not work
            require: 'ngModel',
            link: function (scope, elm, attrs, ctrl) {
                ctrl.$validators.inputvalidator = function (modelValue, viewValue) {
                    let matchResults = blackListRegex.exec(viewValue);
                    scope[ctrl.$name + "_invalid"] = matchResults ? matchResults[0] : '';
                    return !blackListRegex.test(viewValue);
                };
            }
        }
    }
})();
