(function () {
    'use strict';

    angular
        .module('shrine.steward.login')
        .controller('LoginController', LoginController);

    LoginController.$inject = ['LoginModel', 'LoginService', '$location', 'constants'];
    function LoginController(loginModel, loginService, $location, constants) {

        // -- public --//
        var login = this;
        login.data = {};
        login.loginFail = false;
        this.checkLogin = checkLogin;


        // -- private -- //
        function checkLogin() {
            var authdata = loginService.userToBase64(login.data.username, login.data.password);
            loginModel.login(authdata)
                .then(navigateToHome, setLoginToError);
        }

        function navigateToHome(response) {
            loginService.setBearerAuthHeader(response.session);
            loginService.setCredentials(response.userId, response.roles);
            login.data = {};
            $location.path(constants.homeRoute);
        }

        function setLoginToError(response) {
            loginService.clearCredentials();
            login.data = {};
            login.loginFail = true;
            login.status = response.message;
        }
    }
})();
