(function () {
    'use strict';

    angular
        .module('shrine.steward.login')
        .factory('LoginModel', LoginModel);

    LoginModel.$inject = ['$http', '$q', 'StewardService'];
    function LoginModel($http, $q, service) {

        // -- private --//
        var loginModel = this;
        var authFail = 'AuthenticationFailed';
        var url = service.getUrl() + 'user/whoami';

        return {
            login: authenticate
        };

        function authenticate(base64User) {
            const headers = { 'Authorization': 'Basic '+  base64User};
            return $http.get(url, {headers})
                .then(parse, reject);
        }

        function parse(result) {

            return (result.data === 'AuthenticationFailed') ?
                reject(result) : {
                    success: true,
                    msg: result.data.statusText,
                    userId: result.data.userData.userName,
                    roles: result.data.userData.roles,
                    session: result.data.session
                };
        }

        function reject(result, msg) {

            result.data = result.data || 'xhr request timed out';

            var response = {
                success: false,
                message: 'invalid login: ' + result.data
            };

            return $q.reject(response);
        }
    }
})();
