/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.config.migration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.spin.tools.JAXBUtils;
import org.spin.tools.Util;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.Module;
import org.spin.tools.config.NodeConfig;
import org.spin.tools.config.RoutingTableConfig;

public final class Validate {
    private static final Map<String, Class<?>> knownConfigFilenameToClass = Validate.initKnownConfiMag();
    private static final StringBuilder sbOKResults = new StringBuilder();
    private static final StringBuilder sbFailResults = new StringBuilder();
    private static boolean success = false;

    private Validate() {
    }

    private static final Map<String, Class<?>> initKnownConfiMag() {
        HashMap results = Util.makeHashMap();
        results.put(Module.keystore.name() + ".xml", KeyStoreConfig.class);
        results.put(Module.node.name() + ".xml", NodeConfig.class);
        results.put(Module.routingtable.name() + ".xml", RoutingTableConfig.class);
        return results;
    }

    private static final void usage() {
        System.out.println("Usage: Validate <directory with config files>");
        System.out.println("Example:");
        System.out.println("  Usage /home/someUser/configFiles");
        System.out.println("Assumes:");
        System.out.println("  The following file names, if they appear in the given directory,\n  are reserved for spin base config files:");
        for (String fileName : knownConfigFilenameToClass.keySet()) {
            System.out.println("  --> " + fileName);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Validate.usage();
            System.exit(0);
        }
        success = Validate.validateFiles(new File(args[0]));
        System.out.println("=======");
        System.out.println(sbOKResults.toString());
        System.out.println(sbFailResults.toString());
        System.out.println("Done!");
    }

    protected static final boolean validateFiles(File directory) {
        File[] fileArray;
        if (directory.isDirectory()) {
            fileArray = directory.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = directory;
        }
        File[] listOfFiles = fileArray;
        if (directory.isDirectory()) {
            System.out.println("Searching directory <" + directory.getAbsolutePath() + ">");
        }
        for (File f : listOfFiles) {
            if (f.isDirectory()) {
                Validate.validateFiles(f);
                continue;
            }
            String fileName = f.getName();
            if (!knownConfigFilenameToClass.keySet().contains(fileName)) continue;
            try {
                System.out.println("Validating <" + f.getName() + ">");
                JAXBUtils.unmarshalAndValidate((File)f, knownConfigFilenameToClass.get(fileName));
                sbOKResults.append("OK: <" + f.getAbsolutePath() + ">\n");
            }
            catch (JAXBException e) {
                sbFailResults.append("FAIL: <" + f.getAbsolutePath() + ">\n");
                sbFailResults.append("-> " + e.getLinkedException().getMessage() + "\n");
                return false;
            }
        }
        return true;
    }

    protected static final boolean isSuccess() {
        return success;
    }
}

