/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.spin.tools.Util;

public final class FileFilters {
    private FileFilters() {
    }

    public static final FileFilter withExtension(String extension) {
        Util.guardNotNull((Object)extension);
        return FileFilters.withExtensions(Arrays.asList(extension));
    }

    public static final FileFilter withExtensions(String ... extensions) {
        return FileFilters.withExtensions(Arrays.asList(extensions));
    }

    public static final FileFilter withExtensions(Collection<String> extensions) {
        Util.guardNotNull(extensions);
        final ArrayList dottedExtensions = Util.makeArrayList((int)extensions.size());
        for (String extension : extensions) {
            if (extension == null) continue;
            dottedExtensions.add(extension.startsWith(".") ? extension : '.' + extension);
        }
        return new FileFilter(){

            @Override
            public final boolean accept(File pathname) {
                Util.guardNotNull((Object)pathname);
                return FileFilters.endsWithOneOf(pathname.toString(), dottedExtensions);
            }
        };
    }

    static final boolean endsWithOneOf(String string, Collection<String> suffixes) {
        Util.guardNotNull((Object)string);
        Util.guardNotNull(suffixes);
        for (String suffix : suffixes) {
            if (!string.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

