package net.shrine.utilities.batchquerier

import net.shrine.protocol.query.Expression
import scala.xml.XML
import java.io.Reader
import scala.util.Failure
import net.shrine.protocol.query.QueryDefinition
import net.shrine.util.Loggable
import scala.util.Success

/**
 * @author clint
 * @date Sep 6, 2013
 */
abstract class AbstractXmlQueryDefinitionSource(input: Reader) extends QueryDefinitionSource with Loggable {
  override def queryDefs: Iterable[QueryDefinition] = {
    val xml = XML.load(input)
    
    val attempts = for {
      queriesXml <- xml.headOption.toSeq
      queryXml <- queriesXml \ "queryDefinition"
    } yield (queryXml, QueryDefinition.fromXml(queryXml))
    
    val (successes, failures) = attempts.partition { case (_, attempt) => attempt.isSuccess } 
    
    failures.collect { case (queryXml, Failure(_)) => queryXml }.foreach { queryXml =>
      warn(s"Ignoring malformed query definition XML '$queryXml'")
    }
    
    val (_, queryDefAttempts) = attempts.unzip
      
    queryDefAttempts.collect { case Success(queryDef) => queryDef } 
  }
}