package net.shrine.utilities.batchquerier

import net.shrine.protocol.RunQueryResponse
import net.shrine.protocol.ResultOutputType
import net.shrine.protocol.query.QueryDefinition
import net.shrine.protocol.AggregatedRunQueryResponse

/**
 * @author clint
 * @date Sep 6, 2013
 */
trait BatchQuerier { self: HasShrineClient with HasBatchQuerierConfig =>
  import BatchQuerier.Defaults._

  def query(queryDefs: Iterable[QueryDefinition]): Iterable[AggregatedRunQueryResponse] = {
    val shouldBroadcast = true

    queryDefs.map { queryDef =>
      client.runQuery(config.topicId, outputTypes, queryDef, shouldBroadcast)
    }
  }
}

object BatchQuerier {
  object Defaults {
    //TODO: Should this be configurable?
    val outputTypes = Set(ResultOutputType.PATIENT_COUNT_XML)
  }
}