package net.shrine.utilities.batchquerier

import net.shrine.protocol.AggregatedRunQueryResponse
import net.shrine.protocol.QueryResult
import scala.concurrent.duration.Duration
import javax.xml.datatype.XMLGregorianCalendar

/**
 * @author clint
 * @date Sep 10, 2013
 */
object BatchQueryResults {
  def fromAggregatedRunQueryResponse(response: AggregatedRunQueryResponse): Iterable[BatchQueryResult] = {
    def elapsed(queryResult: QueryResult): Option[Duration] = {
      def toMillis(date: XMLGregorianCalendar) = date.toGregorianCalendar.getTimeInMillis
      
      import scala.concurrent.duration._
      
      for {
        startDate <- queryResult.startDate
        endDate <- queryResult.endDate
      } yield (toMillis(endDate) - toMillis(startDate)).milliseconds
    }
    
    response.results.map { queryResult =>
      BatchQueryResult(
          queryResult.description.getOrElse("Unknown institution"), 
          response.requestXml, 
          elapsed(queryResult).getOrElse(Duration.Undefined), 
          queryResult.setSize)
    }
  }
}