/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.io.FileSystem;
import org.specs2.io.FileSystem$$anonfun$org$specs2$io$FileSystem$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystem$class {
    public static Seq filePaths(FileSystem $this, String basePath, String path, boolean verbose) {
        Stream found2 = FileSystem$class.org$specs2$io$FileSystem$$recurse($this, new File(basePath));
        if (verbose) {
            found2.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final void apply(File f) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"found file: ").append((Object)f).toString());
                }
            });
        }
        String pattern = new StringBuilder().append((Object)$this.globToPattern(path)).append((Object)($this.isDir(path) ? "/*.*" : "")).toString();
        if (verbose) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\nThe pattern used to match files is: ").append((Object)pattern).toString());
        }
        scala.collection.immutable.Seq collected = ((scala.collection.immutable.Seq)found2.collect((PartialFunction)new Serializable($this, pattern, verbose){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final String pattern$1;
            private final boolean verbose$1;

            public final <A1 extends File, B1> B1 applyOrElse(A1 x$1, Function1<A1, B1> function1) {
                A1 A1 = x$1;
                Object object = FileSystem$class.org$specs2$io$FileSystem$$fileMatchesPattern(this.$outer, A1, this.pattern$1, this.verbose$1) ? A1.getPath() : function1.apply(x$1);
                return (B1)object;
            }

            public final boolean isDefinedAt(File x$1) {
                File file = x$1;
                boolean bl = FileSystem$class.org$specs2$io$FileSystem$$fileMatchesPattern(this.$outer, file, this.pattern$1, this.verbose$1);
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pattern$1 = pattern$1;
                this.verbose$1 = verbose$1;
            }
        }, Stream$.MODULE$.canBuildFrom())).toSeq();
        return collected;
    }

    public static String filePaths$default$1(FileSystem $this) {
        return ".";
    }

    public static String filePaths$default$2(FileSystem $this) {
        return "*";
    }

    public static boolean filePaths$default$3(FileSystem $this) {
        return false;
    }

    public static boolean org$specs2$io$FileSystem$$isVersionFile(FileSystem $this, File f) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".svn", ".cvs"}))).exists((Function1)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final File f$1;

            public final boolean apply(String x$1) {
                return this.f$1.getPath().contains(x$1);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static boolean org$specs2$io$FileSystem$$fileMatchesPattern(FileSystem $this, File f, String pattern, boolean verbose) {
        String filePath = new StringBuilder().append((Object)"./").append((Object)f.getPath().replace("\\", "/")).toString();
        if (verbose && f.isFile()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)filePath).append((Object)" matches pattern: ").append((Object)BoxesRunTime.boxToBoolean((boolean)filePath.matches(pattern))).toString());
        }
        return f.isFile() && filePath.matches(pattern);
    }

    private static boolean fileMatchesPattern$default$3(FileSystem $this) {
        return false;
    }

    public static Stream org$specs2$io$FileSystem$$recurse(FileSystem $this, File file) {
        return Stream.cons$.MODULE$.apply((Object)file, (Function0)new Serializable($this, file){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final File file$1;

            public final Stream<File> apply() {
                return this.file$1.listFiles() == null ? package$.MODULE$.Stream().empty() : (Stream)((Stream)Predef$.MODULE$.refArrayOps((Object[])this.file$1.listFiles()).toStream().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$$anonfun$org$specs2$io$FileSystem$.recurse.1 $outer;

                    public final boolean apply(File f) {
                        return FileSystem$class.org$specs2$io$FileSystem$$isVersionFile(this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer(), f);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem$$anonfun$org$specs2$io$FileSystem$.recurse.1 $outer;

                    public final Stream<File> apply(File x$2) {
                        return FileSystem$class.org$specs2$io$FileSystem$$recurse(this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer(), x$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, package$.MODULE$.Stream().canBuildFrom());
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.file$1 = file$1;
            }
        });
    }

    public static String globToPattern(FileSystem $this, String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder().append((Object)"[^\\/\\?<>\\|\\").append((Object)star).append((Object)":\"]").append((Object)star).toString();
        String pattern = glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder().append((Object)"(").append((Object)authorizedNamePattern).append((Object)"/)").append((Object)star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
        if (!pattern.startsWith("\\./")) {
            pattern = new StringBuilder().append((Object)"\\./").append((Object)pattern).toString();
        }
        return pattern;
    }

    public static boolean isDir(FileSystem $this, String path) {
        return $this.isDirectory(path);
    }

    public static boolean createDir(FileSystem $this, String path) {
        return new File(path).mkdirs();
    }

    public static String removeDir(FileSystem $this, String path) {
        Object object;
        File dir = new File(path);
        if (dir.isDirectory()) {
            boolean bl;
            if (dir.listFiles() == null || Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).isEmpty()) {
                bl = dir.delete();
            } else {
                Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystem $outer;

                    public final Object apply(File file) {
                        return file.isFile() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : this.$outer.removeDir(file.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                bl = dir.delete();
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            object = BoxedUnit.UNIT;
        }
        return dir.getParent();
    }

    public static boolean canRead(FileSystem $this, String path) {
        return path != null && new File(path).canRead();
    }

    public static boolean canWrite(FileSystem $this, String path) {
        return path != null && new File(path).canWrite();
    }

    public static boolean isAbsolute(FileSystem $this, String path) {
        return path != null && new File(path).isAbsolute();
    }

    public static boolean isFile(FileSystem $this, String path) {
        return path != null && new File(path).isFile();
    }

    public static boolean isDirectory(FileSystem $this, String path) {
        return path != null && new File(path).isDirectory();
    }

    public static boolean isHidden(FileSystem $this, String path) {
        return path != null && new File(path).isHidden();
    }

    public static String getName(FileSystem $this, String path) {
        return new File(path).getName();
    }

    public static String getAbsolutePath(FileSystem $this, String path) {
        return new File(path).getAbsolutePath();
    }

    public static String getCanonicalPath(FileSystem $this, String path) {
        return new File(path).getCanonicalPath();
    }

    public static String getParent(FileSystem $this, String path) {
        return new File(path).getParent();
    }

    public static List listFiles(FileSystem $this, String path) {
        return new File(path).list() == null ? Nil$.MODULE$ : Predef$.MODULE$.refArrayOps((Object[])new File(path).list()).toList();
    }

    public static void copyDir(FileSystem $this, URL url, String dest) {
        $this.copyDir(new File(url.toURI()).getPath(), dest);
    }

    public static void copyDir(FileSystem $this, String src, String dest) {
        ((List)$this.listFiles(src).filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.contains(".svn");
            }
        })).foreach((Function1)new Serializable($this, src, dest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final String src$1;
            private final String dest$1;

            public final void apply(String name) {
                String path = new StringBuilder().append((Object)this.src$1).append((Object)"/").append((Object)name).toString();
                if (new File(path).isDirectory()) {
                    this.$outer.copyDir(path, this.dest$1);
                } else {
                    this.$outer.copyFile(path, this.dest$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$1 = src$1;
                this.dest$1 = dest$1;
            }
        });
    }

    public static void copyFile(FileSystem $this, String path, String dest) {
        $this.mkdirs(dest);
        String destFilePath = new StringBuilder().append((Object)dest).append((Object)"/").append((Object)new File(path).getName()).toString();
        new File(destFilePath).createNewFile();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destFilePath), 2048);
        $this.copy(input, output);
        output.flush();
        output.close();
        input.close();
    }

    public static void unjar(FileSystem $this, String path, String dest) {
        $this.unjar(path, dest, ".*");
    }

    public static void unjar(FileSystem $this, String path, String dirPath, String regexFilter) {
        $this.mkdirs(dirPath);
        FileInputStream fis = new FileInputStream(path);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        Object entry = null;
        FileSystem$class.extractEntry$1($this, zis.getNextEntry(), zis, dirPath, regexFilter);
        zis.close();
    }

    public static void copy(FileSystem $this, InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        FileSystem$class.readData$1($this, input.read(data, 0, 2048), data, input, output);
    }

    public static void copySpecResourcesDir(FileSystem $this, String src, String outputDir) {
        URL jarUrl = Thread.currentThread().getContextClassLoader().getResource(new StringBuilder().append((Object)$this.getClass().getName().replace(".", "/")).append((Object)".class").toString());
        Option$.MODULE$.apply((Object)jarUrl).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(URL url) {
                return url.toString().startsWith("jar");
            }
        }).foreach((Function1)new Serializable($this, src, outputDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final String src$2;
            private final String outputDir$1;

            public final void apply(URL url) {
                this.$outer.unjar(new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(FileSystem$class.org$specs2$io$FileSystem$$getPath(this.$outer, url))).takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$4) {
                        return x$4 != '!';
                    }
                }))).mkString(), this.outputDir$1, new StringBuilder().append((Object)".*").append((Object)this.src$2).append((Object)"/.*").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$2 = src$2;
                this.outputDir$1 = outputDir$1;
            }
        });
        URL folderUrl = Thread.currentThread().getContextClassLoader().getResource(src);
        Option$.MODULE$.apply((Object)folderUrl).withFilter((Function1)new Serializable($this, folderUrl){
            public static final long serialVersionUID = 0L;
            private final URL folderUrl$1;

            public final boolean apply(URL url) {
                return !this.folderUrl$1.toString().startsWith("jar");
            }
            {
                this.folderUrl$1 = folderUrl$1;
            }
        }).foreach((Function1)new Serializable($this, src, outputDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final String src$2;
            private final String outputDir$1;

            public final void apply(URL url) {
                this.$outer.copyDir(url, new StringBuilder().append((Object)this.outputDir$1).append((Object)this.src$2).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.src$2 = src$2;
                this.outputDir$1 = outputDir$1;
            }
        });
    }

    public static boolean samePath(FileSystem $this, String p1, String p2) {
        String string = new File(p1).getCanonicalPath();
        String string2 = new File(p2).getCanonicalPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static String org$specs2$io$FileSystem$$getPath(FileSystem $this, URL url) {
        Object object = scala.sys.package$.MODULE$.props().apply((Object)"file.separator");
        String string = "\\";
        String path = !(object != null ? !object.equals(string) : string != null) ? url.getPath().replace("\\", "/").replace("file:/", "") : url.getPath().replace("file:", "");
        return path.replace("%20", " ");
    }

    private static final void extractEntry$1(FileSystem $this, ZipEntry entry, ZipInputStream zis$1, String dirPath$1, String regexFilter$1) {
        while (entry != null) {
            Object object;
            if (entry.getName().matches(regexFilter$1)) {
                if (entry.isDirectory()) {
                    object = BoxesRunTime.boxToBoolean((boolean)$this.createDir(new StringBuilder().append((Object)dirPath$1).append((Object)"/").append((Object)entry.getName()).toString()));
                } else {
                    $this.createFile(new StringBuilder().append((Object)dirPath$1).append((Object)"/").append((Object)entry.getName()).toString());
                    FileOutputStream fos = new FileOutputStream(new StringBuilder().append((Object)dirPath$1).append((Object)"/").append((Object)entry.getName()).toString());
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    $this.copy(zis$1, dest);
                    dest.flush();
                    dest.close();
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            entry = zis$1.getNextEntry();
        }
        return;
    }

    private static final void readData$1(FileSystem $this, int count, byte[] data$1, InputStream input$1, OutputStream output$1) {
        while (count != -1) {
            output$1.write(data$1, 0, count);
            output$1.flush();
            count = input$1.read(data$1, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

