/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.service;

import net.shrine.aggregation.Aggregator;
import net.shrine.aggregation.DeleteQueryAggregator;
import net.shrine.aggregation.ReadInstanceResultsAggregator;
import net.shrine.aggregation.ReadPdoResponseAggregator;
import net.shrine.aggregation.ReadPreviousQueriesAggregator;
import net.shrine.aggregation.ReadQueryDefinitionAggregator;
import net.shrine.aggregation.ReadQueryInstancesAggregator;
import net.shrine.aggregation.RenameQueryAggregator;
import net.shrine.aggregation.RunQueryAggregator;
import net.shrine.aggregation.SpinResultEntry;
import net.shrine.authorization.QueryAuthorizationService;
import net.shrine.broadcaster.dao.AuditDAO;
import net.shrine.broadcaster.dao.hibernate.AuditEntry;
import net.shrine.config.ShrineConfig;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.BroadcastMessage;
import net.shrine.protocol.BroadcastMessage$;
import net.shrine.protocol.DeleteQueryRequest;
import net.shrine.protocol.ReadApprovedQueryTopicsRequest;
import net.shrine.protocol.ReadApprovedQueryTopicsResponse;
import net.shrine.protocol.ReadInstanceResultsRequest;
import net.shrine.protocol.ReadPdoRequest;
import net.shrine.protocol.ReadPreviousQueriesRequest;
import net.shrine.protocol.ReadQueryDefinitionRequest;
import net.shrine.protocol.ReadQueryInstancesRequest;
import net.shrine.protocol.RenameQueryRequest;
import net.shrine.protocol.RunQueryRequest;
import net.shrine.protocol.ShrineRequest;
import net.shrine.protocol.ShrineRequestHandler;
import net.shrine.protocol.ShrineResponse;
import org.apache.log4j.MDC;
import org.spin.node.acknack.AckNack;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.SpinAgent;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.query.message.identity.IdentityService;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.Identity;
import org.springframework.transaction.annotation.Transactional;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001B\u0001\u0003\u0001%\u0011Qb\u00155sS:,7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\rMD'/\u001b8f\u0015\u00059\u0011a\u00018fi\u000e\u00011\u0003\u0002\u0001\u000b%a\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0011\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003/Q\u0011Ac\u00155sS:,'+Z9vKN$\b*\u00198eY\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"aC*dC2\fwJ\u00196fGRD\u0001b\b\u0001\u0003\u0006\u0004%I\u0001I\u0001\tCV$\u0017\u000e\u001e#b_V\t\u0011\u0005\u0005\u0002#O5\t1E\u0003\u0002%K\u0005\u0019A-Y8\u000b\u0005\u0019\"\u0011a\u00032s_\u0006$7-Y:uKJL!\u0001K\u0012\u0003\u0011\u0005+H-\u001b;E\u0003>C\u0001B\u000b\u0001\u0003\u0002\u0003\u0006I!I\u0001\nCV$\u0017\u000e\u001e#b_\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%I!L\u0001\u0015CV$\bn\u001c:ju\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0003\u0002\u001b\u0005,H\u000f[8sSj\fG/[8o\u0013\t\u0019\u0004GA\rRk\u0016\u0014\u00180Q;uQ>\u0014\u0018N_1uS>t7+\u001a:wS\u000e,\u0007\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002+\u0005,H\u000f[8sSj\fG/[8o'\u0016\u0014h/[2fA!Aq\u0007\u0001BC\u0002\u0013%\u0001(A\bjI\u0016tG/\u001b;z'\u0016\u0014h/[2f+\u0005I\u0004C\u0001\u001eF\u001b\u0005Y$B\u0001\u001f>\u0003!IG-\u001a8uSRL(B\u0001 @\u0003\u001diWm]:bO\u0016T!\u0001Q!\u0002\u000bE,XM]=\u000b\u0005\t\u001b\u0015\u0001B:qS:T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$<\u0005=IE-\u001a8uSRL8+\u001a:wS\u000e,\u0007\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002!%$WM\u001c;jif\u001cVM\u001d<jG\u0016\u0004\u0003\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011B&\u0002\u0019MD'/\u001b8f\u0007>tg-[4\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\u0003\u0002\r\r|gNZ5h\u0013\t\tfJ\u0001\u0007TQJLg.Z\"p]\u001aLw\r\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003M\u00035\u0019\bN]5oK\u000e{gNZ5hA!AQ\u000b\u0001BC\u0002\u0013%a+\u0001\u0006ta&t7\t\\5f]R,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035v\nQ!Y4f]RL!\u0001X-\u0003\u0013M\u0003\u0018N\\!hK:$\b\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B,\u0002\u0017M\u0004\u0018N\\\"mS\u0016tG\u000f\t\u0005\u0006A\u0002!\t!Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\t$WMZ4i!\t\u0019\u0007!D\u0001\u0003\u0011\u0015yr\f1\u0001\"\u0011\u0015as\f1\u0001/\u0011\u00159t\f1\u0001:\u0011\u0015Qu\f1\u0001M\u0011\u0015)v\f1\u0001X\u0011!Q\u0007\u0001#b\u0001\n\u0013Y\u0017AD3oIB|\u0017N\u001c;D_:4\u0017nZ\u000b\u0002YB\u0011Q.]\u0007\u0002]*\u0011qj\u001c\u0006\u0003a\u0006\u000bQ\u0001^8pYNL!A\u001d8\u0003\u001d\u0015sG\r]8j]R\u001cuN\u001c4jO\"AA\u000f\u0001E\u0001B\u0003&A.A\bf]\u0012\u0004x.\u001b8u\u0007>tg-[4!\u0011\u00151\b\u0001\"\u0005x\u0003A9WM\\3sCR,\u0017\nZ3oi&$\u0018\u0010F\u0002y\u0003\u0003\u0001\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0013MLwM\\1ukJ,'BA?p\u0003\u0019\u0019'/\u001f9u_&\u0011qP\u001f\u0002\t\u0013\u0012,g\u000e^5us\"9\u00111A;A\u0002\u0005\u0015\u0011!B1vi\"t\u0007cA\n\u0002\b%\u0019\u0011\u0011\u0002\u000b\u0003%\u0005+H\u000f[3oi&\u001c\u0017\r^5p]&sgm\u001c\u0005\t\u0003\u001b\u0001A\u0011\u0001\u0002\u0002\u0010\u0005\u0011B-\u001a;fe6Lg.\u001a)fKJ<'o\\;q)\u0011\t\t\"a\u0006\u0011\u0007-\t\u0019\"C\u0002\u0002\u00161\u0011aa\u0015;sS:<\u0007\u0002CA\r\u0003\u0017\u0001\r!!\u0005\u0002\u0013A\u0014xN[3di&#\u0007\u0002CA\u000f\u0001\u0011\u0005!!a\b\u0002!\t\u0014x.\u00193dCN$X*Z:tC\u001e,GCBA\u0011\u0003c\tI\u0004\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u000f\u0005\u001c7N\\1dW*\u0019\u00111F!\u0002\t9|G-Z\u0005\u0005\u0003_\t)CA\u0004BG.t\u0015mY6\t\u000fy\nY\u00021\u0001\u00024A\u00191#!\u000e\n\u0007\u0005]BC\u0001\tCe>\fGmY1ti6+7o]1hK\"A\u00111HA\u000e\u0001\u0004\ti$A\u0005rk\u0016\u0014\u00180\u00138g_B!\u0011qHA#\u001b\t\t\tEC\u0002\u0002Du\nq\u0001[3bI\u0016\u00148/\u0003\u0003\u0002H\u0005\u0005#!C)vKJL\u0018J\u001c4p\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001b\nabZ3u'BLgNU3tk2$8\u000f\u0006\u0004\u0002P\u0005U\u0013\u0011\f\t\u0005\u0003\u007f\t\t&\u0003\u0003\u0002T\u0005\u0005#!\u0003*fgVdGoU3u\u0011!\t9&!\u0013A\u0002\u0005E\u0011aB9vKJL\u0018\n\u0012\u0005\u0007y\u0005%\u0003\u0019\u0001=\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005I\u0011mZ4sK\u001e\fG/\u001a\u000b\t\u0003C\n9'a\u001b\u0002nA\u00191#a\u0019\n\u0007\u0005\u0015DC\u0001\bTQJLg.\u001a*fgB|gn]3\t\u0011\u0005%\u00141\fa\u0001\u0003#\tq!];fefLE\r\u0003\u0004=\u00037\u0002\r\u0001\u001f\u0005\t\u0003_\nY\u00061\u0001\u0002r\u0005Q\u0011mZ4sK\u001e\fGo\u001c:\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u0005\u0003-\twm\u001a:fO\u0006$\u0018n\u001c8\n\t\u0005m\u0014Q\u000f\u0002\u000b\u0003\u001e<'/Z4bi>\u0014\bbBA@\u0001\u0011E\u0011\u0011Q\u0001\u000fKb,7-\u001e;f%\u0016\fX/Z:u)!\t\t'a!\u0002\u0006\u0006\u001d\u0005B\u0002\u001f\u0002~\u0001\u0007\u0001\u0010C\u0004?\u0003{\u0002\r!a\r\t\u0011\u0005=\u0014Q\u0010a\u0001\u0003cBq!a \u0001\t#\tY\t\u0006\u0004\u0002b\u00055\u0015q\u0013\u0005\t\u0003\u001f\u000bI\t1\u0001\u0002\u0012\u00069!/Z9vKN$\bcA\n\u0002\u0014&\u0019\u0011Q\u0013\u000b\u0003\u001bMC'/\u001b8f%\u0016\fX/Z:u\u0011!\ty'!#A\u0002\u0005E\u0004bBAN\u0001\u0011%\u0011QT\u0001\u0006Y><\u0017\nZ\u000b\u0003\u0003?\u00032!GAQ\u0013\r\t\u0019K\u0007\u0002\u0005\u0019>tw\rC\u0004\u0002(\u0002!I!!+\u0002)\u0005,H-\u001b;Sk:\fV/\u001a:z%\u0016\fX/Z:u)\u0019\tY+!-\u00024B\u0019\u0011$!,\n\u0007\u0005=&D\u0001\u0003V]&$\bB\u0002\u001f\u0002&\u0002\u0007\u0001\u0010\u0003\u0005\u0002\u0010\u0006\u0015\u0006\u0019AA[!\r\u0019\u0012qW\u0005\u0004\u0003s#\"a\u0004*v]F+XM]=SKF,Xm\u001d;\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u0006A!/\u001e8Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002b\u0005\u0005\u0007\u0002CAH\u0003w\u0003\r!!.)\t\u0005m\u0016Q\u0019\t\u0005\u0003\u000f\f).\u0004\u0002\u0002J*!\u00111ZAg\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u001f\f\t.A\u0006ue\u0006t7/Y2uS>t'bAAj\u0007\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002X\u0006%'!\u0004+sC:\u001c\u0018m\u0019;j_:\fG\u000eC\u0004\u0002\\\u0002!\t!!8\u0002'I,\u0017\rZ)vKJLH)\u001a4j]&$\u0018n\u001c8\u0015\t\u0005\u0005\u0014q\u001c\u0005\t\u0003\u001f\u000bI\u000e1\u0001\u0002bB\u00191#a9\n\u0007\u0005\u0015HC\u0001\u000eSK\u0006$\u0017+^3ss\u0012+g-\u001b8ji&|gNU3rk\u0016\u001cH\u000fC\u0004\u0002j\u0002!\t!a;\u0002\u000fI,\u0017\r\u001a)e_R!\u0011\u0011MAw\u0011!\ty)a:A\u0002\u0005=\bcA\n\u0002r&\u0019\u00111\u001f\u000b\u0003\u001dI+\u0017\r\u001a)e_J+\u0017/^3ti\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\u0018a\u0005:fC\u0012Len\u001d;b]\u000e,'+Z:vYR\u001cH\u0003BA1\u0003wD\u0001\"a$\u0002v\u0002\u0007\u0011Q \t\u0004'\u0005}\u0018b\u0001B\u0001)\tQ\"+Z1e\u0013:\u001cH/\u00198dKJ+7/\u001e7ugJ+\u0017/^3ti\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0011A\u0005:fC\u0012\fV/\u001a:z\u0013:\u001cH/\u00198dKN$B!!\u0019\u0003\n!A\u0011q\u0012B\u0002\u0001\u0004\u0011Y\u0001E\u0002\u0014\u0005\u001bI1Aa\u0004\u0015\u0005e\u0011V-\u00193Rk\u0016\u0014\u00180\u00138ti\u0006t7-Z:SKF,Xm\u001d;\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016\u0005\u0019\"/Z1e!J,g/[8vgF+XM]5fgR!\u0011\u0011\rB\f\u0011!\tyI!\u0005A\u0002\te\u0001cA\n\u0003\u001c%\u0019!Q\u0004\u000b\u00035I+\u0017\r\u001a)sKZLw.^:Rk\u0016\u0014\u0018.Z:SKF,Xm\u001d;\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$\u0005Y!/\u001a8b[\u0016\fV/\u001a:z)\u0011\t\tG!\n\t\u0011\u0005=%q\u0004a\u0001\u0005O\u00012a\u0005B\u0015\u0013\r\u0011Y\u0003\u0006\u0002\u0013%\u0016t\u0017-\\3Rk\u0016\u0014\u0018PU3rk\u0016\u001cH\u000fC\u0004\u00030\u0001!\tA!\r\u0002\u0017\u0011,G.\u001a;f#V,'/\u001f\u000b\u0005\u0003C\u0012\u0019\u0004\u0003\u0005\u0002\u0010\n5\u0002\u0019\u0001B\u001b!\r\u0019\"qG\u0005\u0004\u0005s!\"A\u0005#fY\u0016$X-U;fef\u0014V-];fgRDqA!\u0010\u0001\t\u0003\u0011y$A\fsK\u0006$\u0017\t\u001d9s_Z,G-U;fef$v\u000e]5dgR!!\u0011\tB$!\r\u0019\"1I\u0005\u0004\u0005\u000b\"\"a\b*fC\u0012\f\u0005\u000f\u001d:pm\u0016$\u0017+^3ssR{\u0007/[2t%\u0016\u001c\bo\u001c8tK\"A\u0011q\u0012B\u001e\u0001\u0004\u0011I\u0005E\u0002\u0014\u0005\u0017J1A!\u0014\u0015\u0005y\u0011V-\u00193BaB\u0014xN^3e#V,'/\u001f+pa&\u001c7OU3rk\u0016\u001cH\u000f")
public class ShrineService
implements ShrineRequestHandler,
ScalaObject {
    private final AuditDAO auditDao;
    private final QueryAuthorizationService authorizationService;
    private final IdentityService identityService;
    private final ShrineConfig shrineConfig;
    private final SpinAgent spinClient;
    private EndpointConfig endpointConfig;
    private volatile int bitmap$priv$0;

    private AuditDAO auditDao() {
        return this.auditDao;
    }

    private QueryAuthorizationService authorizationService() {
        return this.authorizationService;
    }

    private IdentityService identityService() {
        return this.identityService;
    }

    private ShrineConfig shrineConfig() {
        return this.shrineConfig;
    }

    private SpinAgent spinClient() {
        return this.spinClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EndpointConfig endpointConfig() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.endpointConfig;
        ShrineService shrineService = this;
        synchronized (shrineService) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.endpointConfig = new EndpointConfig(EndpointType.SOAP, this.shrineConfig().getAggregatorEndpoint());
                this.bitmap$priv$0 |= 1;
            }
            return this.endpointConfig;
        }
    }

    public Identity generateIdentity(AuthenticationInfo authn) {
        return this.identityService().certify(authn.domain(), authn.username(), authn.credential().value());
    }

    public String determinePeergroup(String projectId) {
        return this.shrineConfig().getBroadcasterPeerGroupToQuery() == null ? projectId : this.shrineConfig().getBroadcasterPeerGroupToQuery();
    }

    /*
     * WARNING - void declaration
     */
    public AckNack broadcastMessage(BroadcastMessage message, QueryInfo queryInfo) {
        void var3_3;
        AckNack ackNack = this.spinClient().send(queryInfo, (Object)message, BroadcastMessage$.MODULE$.serializer());
        if (ackNack.isError()) {
            throw new AgentException("Error encountered during query.");
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ResultSet getSpinResults(String queryID, Identity identity) {
        void var3_3;
        ResultSet exceptionResult1 = null;
        try {
            exceptionResult1 = this.spinClient().receive(queryID, identity);
        }
        catch (TimeoutException timeoutException) {
            exceptionResult1 = this.spinClient().getResult(queryID, identity);
        }
        return var3_3;
    }

    private ShrineResponse aggregate(String queryId, Identity identity, Aggregator aggregator) {
        ResultSet spinResults = this.getSpinResults(queryId, identity);
        Iterable spinResultEntries = (Iterable)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)spinResults).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final SpinResultEntry apply(Result x) {
                return new SpinResultEntry(new PKCryptor().decrypt(x.getPayload()), x);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ShrineResponse responseMessageType = aggregator.aggregate((Seq<SpinResultEntry>)spinResultEntries.toSeq());
        return responseMessageType;
    }

    public ShrineResponse executeRequest(Identity identity, BroadcastMessage message, Aggregator aggregator) {
        AckNack ackNack = this.broadcastMessage(message, new QueryInfo(this.determinePeergroup(message.request().projectId()), identity, message.request().requestType().name(), this.endpointConfig()));
        return this.aggregate(ackNack.getQueryID(), identity, aggregator);
    }

    public ShrineResponse executeRequest(ShrineRequest request, Aggregator aggregator) {
        return this.executeRequest(this.generateIdentity(request.authn()), new BroadcastMessage(this.logId(), request), aggregator);
    }

    private long logId() {
        return BoxesRunTime.unboxToLong((Object)MDC.get((String)"globalRequestId"));
    }

    private void auditRunQueryRequest(Identity identity, RunQueryRequest request) {
        this.auditDao().addAuditEntry(new AuditEntry(request.projectId(), identity.getDomain(), identity.getUsername(), request.queryDefinitionXml(), request.topicId()));
    }

    @Transactional
    public ShrineResponse runQuery(RunQueryRequest request) {
        this.authorizationService().authorizeRunQueryRequest(request);
        Identity identity = this.generateIdentity(request.authn());
        this.auditRunQueryRequest(identity, request);
        BroadcastMessage message = BroadcastMessage$.MODULE$.apply(request);
        RunQueryAggregator aggregator = new RunQueryAggregator(BoxesRunTime.unboxToLong((Object)message.masterId().get()), request.authn().username(), request.projectId(), request.queryDefinitionXml(), BoxesRunTime.unboxToLong((Object)message.instanceId().get()), Predef$.MODULE$.Boolean2boolean(this.shrineConfig().isIncludeAggregateResult()));
        return this.executeRequest(identity, message, aggregator);
    }

    public ShrineResponse readQueryDefinition(ReadQueryDefinitionRequest request) {
        return this.executeRequest((ShrineRequest)request, new ReadQueryDefinitionAggregator());
    }

    public ShrineResponse readPdo(ReadPdoRequest request) {
        return this.executeRequest((ShrineRequest)request, new ReadPdoResponseAggregator());
    }

    public ShrineResponse readInstanceResults(ReadInstanceResultsRequest request) {
        return this.executeRequest((ShrineRequest)request, new ReadInstanceResultsAggregator(request.instanceId(), false));
    }

    public ShrineResponse readQueryInstances(ReadQueryInstancesRequest request) {
        return this.executeRequest((ShrineRequest)request, new ReadQueryInstancesAggregator(request.queryId(), request.authn().username(), request.projectId()));
    }

    public ShrineResponse readPreviousQueries(ReadPreviousQueriesRequest request) {
        return this.executeRequest((ShrineRequest)request, new ReadPreviousQueriesAggregator(request.authn().username(), request.projectId()));
    }

    public ShrineResponse renameQuery(RenameQueryRequest request) {
        return this.executeRequest((ShrineRequest)request, new RenameQueryAggregator());
    }

    public ShrineResponse deleteQuery(DeleteQueryRequest request) {
        return this.executeRequest((ShrineRequest)request, new DeleteQueryAggregator());
    }

    public ReadApprovedQueryTopicsResponse readApprovedQueryTopics(ReadApprovedQueryTopicsRequest request) {
        return this.authorizationService().readApprovedEntries(request);
    }

    public ShrineService(AuditDAO auditDao, QueryAuthorizationService authorizationService, IdentityService identityService, ShrineConfig shrineConfig, SpinAgent spinClient) {
        this.auditDao = auditDao;
        this.authorizationService = authorizationService;
        this.identityService = identityService;
        this.shrineConfig = shrineConfig;
        this.spinClient = spinClient;
    }
}

