/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import edu.harvard.i2b2.crc.datavo.pdo.query.GetPDOFromInputListRequestType;
import java.io.StringWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.shrine.authorization.AuthorizationService;
import net.shrine.broadcaster.BroadcasterAggregatorException;
import net.shrine.broadcaster.BroadcasterAggregatorSOAP;
import net.shrine.broadcaster.aggregators.GenericAggregator;
import net.shrine.broadcaster.aggregators.PDOAggregator;
import net.shrine.broadcaster.aggregators.PatientSetAggregator;
import net.shrine.broadcaster.aggregators.ShrineResultAggregator;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.config.ShrineConfig;
import net.shrine.serializers.ShrineHeader;
import net.shrine.serializers.ShrineMessage;
import net.shrine.serializers.crc.CRCRequestType;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import net.shrine.serializers.hive.HiveJaxbContext;
import org.apache.log4j.Logger;
import org.spin.node.NodeException;
import org.spin.node.acknack.AckNack;
import org.spin.query.message.agent.Agent;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.cache.CacheException;
import org.spin.query.message.cache.QueryNotFoundException;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.serializer.BasicSerializer;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class BroadcasterAggregator {
    public static final Logger log = Logger.getLogger(BroadcasterAggregatorSOAP.class);
    public static final boolean DEBUG = log.isDebugEnabled();
    public static final boolean INFO = log.isInfoEnabled();
    private final Agent spinClient;
    private final QueryInfo queryInfoHeader;
    private final IdentityService identityService;
    private final SecureRandom rand;
    private final AuthorizationService authorizationService;
    private String broadcasterPeerGroupToQuery;

    @Autowired
    public BroadcasterAggregator(ShrineConfig shrineConfig, IdentityService identityService, Agent spinClient, AuthorizationService authorizationService) throws NodeException, ConfigException {
        this.authorizationService = authorizationService;
        this.rand = new SecureRandom();
        this.spinClient = spinClient;
        this.broadcasterPeerGroupToQuery = shrineConfig.getBroadcasterPeerGroupToQuery();
        this.queryInfoHeader = new QueryInfo(this.broadcasterPeerGroupToQuery, null, null, new EndpointConfig(EndpointType.SOAP, shrineConfig.getAggregatorEndpoint()));
        this.identityService = identityService;
    }

    public ResponseMessageType execute(RequestMessageType request) {
        try {
            List any = request.getMessageBody().getAny();
            if (any.size() < 2) {
                log.error((Object)("Unexpected  number of parameters in request object: " + any.size()));
                return HiveCommonSerializer.getTemplateResponseMessageTypeError((RequestMessageType)request, (String)"Unexpected request parameters");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not determine request type. Returning empty response templated by the request object.", (Throwable)e);
            return HiveCommonSerializer.getTemplateResponseMessageTypeError((RequestMessageType)request, (String)e.getMessage());
        }
        try {
            CRCRequestType requestType = CRCSerializer.getRequestType((RequestMessageType)request);
            if (requestType == CRCRequestType.SheriffRequestType) {
                ResponseMessageType response = this.authorizationService.readApprovedEntries(request);
                return response;
            }
            if (requestType == CRCRequestType.GetPDOFromInputListRequestType) {
                this.authorizationService.authorizeRequest(request);
                GetPDOFromInputListRequestType pdo = CRCSerializer.getPDOInputListRequest((RequestMessageType)request);
                CRCSerializer.updatePDORequest((RequestMessageType)request, (GetPDOFromInputListRequestType)pdo);
                return this.runQuery(requestType, new PDOAggregator(), request);
            }
            if (requestType == CRCRequestType.QueryDefinitionRequestType) {
                this.authorizationService.authorizeRequest(request);
                return this.runQueryFromQueryDefinition(request);
            }
            return this.runQuery(requestType, BroadcasterAggregator.determineAggregator(requestType), request);
        }
        catch (Exception e) {
            log.debug((Object)"Error Executing Query", (Throwable)e);
            return HiveCommonSerializer.getTemplateResponseMessageTypeError((RequestMessageType)request, (String)"Error Executing Query");
        }
    }

    private static final ShrineResultAggregator determineAggregator(CRCRequestType requestType) throws BroadcasterAggregatorException {
        if (requestType == CRCRequestType.GetRequestXml) {
            return GenericAggregator.GetRequestXmlResponseType;
        }
        if (requestType == CRCRequestType.UserRequestType) {
            return GenericAggregator.MasterResponseType;
        }
        if (requestType == CRCRequestType.MasterRequestType) {
            return GenericAggregator.InstanceResponseType;
        }
        if (requestType == CRCRequestType.InstanceRequestType) {
            return GenericAggregator.ResultResponseType;
        }
        if (requestType == CRCRequestType.ResultRequestType) {
            return GenericAggregator.ResultResponseType;
        }
        throw new BroadcasterAggregatorException("Unknown request type");
    }

    private ResponseMessageType runQuery(CRCRequestType requestType, ShrineResultAggregator aggregator, RequestMessageType request) {
        Util.guardNotNull((Object)requestType);
        Util.guardNotNull((Object)aggregator);
        Util.guardNotNull((Object)request);
        return this.runQuery(requestType.name(), Long.toString(this.makeRandomID()), aggregator, new ShrineHeader(), request);
    }

    private long makeRandomID() {
        return Math.abs(this.rand.nextLong());
    }

    protected ResponseMessageType runQueryFromQueryDefinition(RequestMessageType request) throws SerializationException {
        ShrineHeader header = this.makeShrineHeaderWithGeneratedIDs(request);
        return this.runQuery("RunQueryInstanceFromQueryDefinition", Long.toString(header.getQueryMasterId()), new PatientSetAggregator(), header, request);
    }

    private ShrineHeader makeShrineHeaderWithGeneratedIDs(RequestMessageType request) throws SerializationException {
        long queryMasterId = this.makeRandomID();
        long queryInstanceId = this.makeRandomID();
        List<Long> queryResultIds = this.makeRandomResultIDs(request);
        return new ShrineHeader(Long.valueOf(queryMasterId), Long.valueOf(queryInstanceId), queryResultIds, request);
    }

    private List<Long> makeRandomResultIDs(RequestMessageType request) throws SerializationException {
        ArrayList queryResultIds = Util.makeArrayList();
        int size = CRCSerializer.getQueryDefinitionRequest((RequestMessageType)request).getResultOutputList().getResultOutput().size();
        for (Integer i : Util.range((int)size)) {
            queryResultIds.add(this.makeRandomID());
        }
        return queryResultIds;
    }

    protected ResponseMessageType runQuery(String requestType, String requestId, ShrineResultAggregator aggregator, ShrineHeader header, RequestMessageType request) {
        Collection<Result> spinResults;
        AckNack ackNack;
        QueryInfo newQueryInfo;
        try {
            if (DEBUG) {
                log.debug((Object)"Certifying the investigator.");
            }
            SecurityType credentials = HiveCommonSerializer.getSecurityType((RequestMessageType)request);
            Identity investigatorSigned = this.identityService.certify(credentials.getDomain(), credentials.getUsername(), credentials.getPassword().getValue());
            String peerGroup = this.determinePeergroup(requestType, request);
            if (DEBUG) {
                log.debug((Object)"Creating query info header and attaching the W3C signed investigator identity using this machine's certificate.");
            }
            newQueryInfo = this.makeNewQueryInfoHeader(requestType, peerGroup).withIdentity(investigatorSigned);
            if (DEBUG) {
                log.debug((Object)"Creating Shrine message");
            }
            ShrineMessage shrineMessage = new ShrineMessage(header, (Object)request);
            if (DEBUG) {
                log.debug((Object)"Attempting to send the query to all nodes NOW (asynchronous broadcast)");
            }
            BasicSerializer<Object> serializer = new BasicSerializer<Object>(){

                public String toString(Object o) throws SerializationException {
                    try {
                        Marshaller marshaller = HiveJaxbContext.getInstance().getContext().createMarshaller();
                        StringWriter writer = new StringWriter();
                        marshaller.marshal(o, (Writer)writer);
                        return writer.toString();
                    }
                    catch (JAXBException e) {
                        throw new SerializationException((Exception)((Object)e));
                    }
                }

                public Object fromString(String s) throws SerializationException {
                    throw new UnsupportedOperationException("Deserialization not supported");
                }
            };
            ackNack = this.spinClient.send(newQueryInfo, (Object)shrineMessage, (BasicSerializer)serializer);
            if (INFO) {
                log.info((Object)("Sent query " + ackNack.getQueryID() + "' with query type '" + newQueryInfo.getQueryType() + "'. Node response: " + ackNack.getStatuses()));
            }
            if (ackNack.isError()) {
                throw new AgentException("Error encountered during query.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to send query", (Throwable)e);
            return HiveCommonSerializer.getTemplateResponseMessageTypeError((RequestMessageType)request, (String)e.getMessage());
        }
        try {
            if (DEBUG) {
                log.debug((Object)"Waiting for responses from all nodes. This is a lot of waiting for the user, we should return async!");
            }
            spinResults = this.getSpinResults(ackNack.getQueryID(), newQueryInfo.getIdentity());
        }
        catch (Exception e) {
            log.error((Object)"Failed to get the aggregated result from the cache.", (Throwable)e);
            return HiveCommonSerializer.getTemplateResponseMessageTypeError((RequestMessageType)request, (String)e.getMessage());
        }
        try {
            ArrayList spinResultEntries = Util.makeArrayList((int)spinResults.size());
            PKCryptor cryptor = new PKCryptor();
            for (Result spinResult : spinResults) {
                spinResultEntries.add(new SpinResultEntry(cryptor.decrypt(spinResult.getPayload()), spinResult));
            }
            if (DEBUG) {
                log.debug((Object)"Now attempting to aggregate replies. If a single reply fails continue anyway.");
            }
            return aggregator.aggregate(requestId, spinResultEntries, request);
        }
        catch (Exception e) {
            log.warn((Object)"Performed aggregation but a single node i2b2Response failed.", (Throwable)e);
            return null;
        }
    }

    private Collection<Result> getSpinResults(String queryID, Identity identity) throws CacheException, QueryNotFoundException {
        try {
            return this.spinClient.receive(queryID, identity);
        }
        catch (TimeoutException e) {
            log.warn((Object)"TimeoutException occured ", (Throwable)e);
            return this.spinClient.getResult(queryID, identity);
        }
    }

    String determinePeergroup(String requestType, RequestMessageType request) {
        return this.broadcasterPeerGroupToQuery;
    }

    protected ResponseMessageType getPreviousQueries() {
        return null;
    }

    private QueryInfo makeNewQueryInfoHeader(String requestType, String peerGroup) {
        QueryInfo newQueryInfoHeader = new QueryInfo();
        newQueryInfoHeader.setQueryType(requestType);
        if (peerGroup != null) {
            newQueryInfoHeader.setPeerGroup(peerGroup);
        } else {
            newQueryInfoHeader.setPeerGroup(this.queryInfoHeader.getPeerGroup());
        }
        newQueryInfoHeader.setAggregator(this.queryInfoHeader.getAggregator());
        return newQueryInfoHeader;
    }
}

