/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.aggregators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.pdo.EventSet;
import edu.harvard.i2b2.crc.datavo.pdo.ObservationSet;
import edu.harvard.i2b2.crc.datavo.pdo.PatientDataType;
import edu.harvard.i2b2.crc.datavo.pdo.PatientSet;
import edu.harvard.i2b2.crc.datavo.pdo.query.PatientDataResponseType;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.shrine.broadcaster.aggregators.ShrineResultAggregator;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;

public final class PDOAggregator
implements ShrineResultAggregator {
    private static final Logger log = Logger.getLogger(PDOAggregator.class);

    @Override
    public ResponseMessageType aggregate(String queryID, Collection<SpinResultEntry> spinCacheResults, RequestMessageType request) throws SerializationException {
        ResponseMessageType aggregatedResponse = CRCSerializer.getTemplateResponseMessageType((RequestMessageType)request);
        PatientDataResponseType aggregatedList = this.makeEmptyPatientDataResponse();
        for (SpinResultEntry result : spinCacheResults) {
            ResponseMessageType singleCRCResponse;
            try {
                singleCRCResponse = HiveCommonSerializer.getResponse((String)result.getSpinResultXml());
            }
            catch (JAXBException e) {
                log.error((Object)("could not read response, skipping: " + result.getSpinResultXml()), (Throwable)e);
                continue;
            }
            try {
                PatientSet patients;
                PatientDataResponseType patientData = CRCSerializer.getPatientDataResponseType((ResponseMessageType)singleCRCResponse);
                if (patientData.getPatientData() == null) continue;
                EventSet events = patientData.getPatientData().getEventSet();
                if (events != null) {
                    aggregatedList.getPatientData().getEventSet().getEvent().addAll(events.getEvent());
                }
                if ((patients = patientData.getPatientData().getPatientSet()) != null) {
                    aggregatedList.getPatientData().getPatientSet().getPatient().addAll(patients.getPatient());
                }
                List observationSets = patientData.getPatientData().getObservationSet();
                for (ObservationSet observationSet : observationSets) {
                    boolean observationsAggregated = false;
                    for (ObservationSet aggObservationSet : aggregatedList.getPatientData().getObservationSet()) {
                        if (!observationSet.getPanelName().equals(aggObservationSet)) continue;
                        aggObservationSet.getObservation().addAll(observationSet.getObservation());
                        observationsAggregated = true;
                        break;
                    }
                    if (observationsAggregated) continue;
                    aggregatedList.getPatientData().getObservationSet().add(observationSet);
                }
            }
            catch (SerializationException e) {
                log.error((Object)"problem serializing patient data, skipping", (Throwable)e);
            }
        }
        CRCSerializer.addPatientDataResponse((ResponseMessageType)aggregatedResponse, (PatientDataResponseType)aggregatedList);
        return aggregatedResponse;
    }

    private PatientDataResponseType makeEmptyPatientDataResponse() {
        PatientDataType pdt = new PatientDataType();
        pdt.setEventSet(new EventSet());
        pdt.setPatientSet(new PatientSet());
        PatientDataResponseType ret = new PatientDataResponseType();
        ret.setPatientData(pdt);
        return ret;
    }
}

