/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.broadcaster.aggregators;

import edu.harvard.i2b2.crc.datavo.i2b2message.RequestMessageType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseHeaderType;
import edu.harvard.i2b2.crc.datavo.i2b2message.ResponseMessageType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.MasterInstanceResultResponseType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultInstanceType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryResultTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.QueryStatusTypeType;
import edu.harvard.i2b2.crc.datavo.setfinder.query.StatusType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shrine.broadcaster.aggregators.ShrineResultAggregator;
import net.shrine.broadcaster.aggregators.SpinResultEntry;
import net.shrine.serializers.crc.CRCSerializer;
import net.shrine.serializers.hive.HiveCommonSerializer;
import org.apache.log4j.Logger;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

public final class PatientSetAggregator
implements ShrineResultAggregator {
    private static final Logger log = Logger.getLogger(PatientSetAggregator.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private int setSize = 0;
    private final List<ResponseMessageType> siteResponsesCompleted = Util.makeArrayList();
    private final List<ResponseMessageType> siteResponsesError = Util.makeArrayList();

    private ResponseMessageType convert(SpinResultEntry result) {
        try {
            return HiveCommonSerializer.getResponse((String)result.getSpinResultXml());
        }
        catch (Exception e) {
            log.error((Object)"Failed to deserialize Result payload from Adapter.");
            return null;
        }
    }

    @Override
    public ResponseMessageType aggregate(String masterId, Collection<SpinResultEntry> spinCacheResults, RequestMessageType request) throws SerializationException {
        ResponseMessageType aggregatedResponse = HiveCommonSerializer.getTemplateResponseMessageType((RequestMessageType)request);
        if (spinCacheResults.isEmpty()) {
            MasterInstanceResultResponseType master = new MasterInstanceResultResponseType();
            StatusType status = new StatusType();
            StatusType.Condition condition = new StatusType.Condition();
            condition.setCodingSystem("coding");
            condition.setType("ERROR");
            condition.setValue("ERROR");
            status.getCondition().add(condition);
            master.setStatus(status);
            CRCSerializer.addMasterResultInstanceResponse((ResponseMessageType)aggregatedResponse, (MasterInstanceResultResponseType)master);
            aggregatedResponse.setResponseHeader(new ResponseHeaderType(HiveCommonSerializer.getResultStatusError((String)"ERROR")));
            return aggregatedResponse;
        }
        boolean first = true;
        MasterInstanceResultResponseType master = new MasterInstanceResultResponseType();
        for (SpinResultEntry result : spinCacheResults) {
            ResponseMessageType singleCRCResponse = this.convert(result);
            if (!CRCSerializer.isCompletedQuery((ResponseMessageType)singleCRCResponse)) {
                log.warn((Object)"Skipping crc response, results are unavailable.");
                this.siteResponsesError.add(singleCRCResponse);
                continue;
            }
            String singleSiteQueryID = CRCSerializer.getQueryMasterID((ResponseMessageType)singleCRCResponse);
            if (!masterId.equals(singleSiteQueryID)) {
                log.warn((Object)("Expected masterId " + masterId + " but found " + singleSiteQueryID));
                this.siteResponsesError.add(singleCRCResponse);
                continue;
            }
            this.siteResponsesCompleted.add(singleCRCResponse);
            if (first) {
                MasterInstanceResultResponseType firstResponseMaster = CRCSerializer.getQueryMaster((ResponseMessageType)singleCRCResponse);
                master.setStatus(firstResponseMaster.getStatus());
                master.setQueryMaster(firstResponseMaster.getQueryMaster());
                master.setQueryInstance(firstResponseMaster.getQueryInstance());
                first = false;
            }
            List siteSpecificResults = CRCSerializer.getQueryResults((ResponseMessageType)singleCRCResponse);
            for (int i = 0; i < siteSpecificResults.size(); ++i) {
                QueryResultInstanceType siteResult = (QueryResultInstanceType)siteSpecificResults.get(i);
                siteResult.setDescription(result.getSpinResultMetadata().getDescription());
                master.getQueryResultInstance().add(siteResult);
                if (!siteResult.getQueryResultType().getName().equals("PATIENT_COUNT_XML") || siteResult.getSetSize() == -1) continue;
                this.setSize += siteResult.getSetSize();
            }
        }
        master.getQueryResultInstance().add(PatientSetAggregator.getAggregateSummary(masterId, this.setSize));
        CRCSerializer.addMasterResultInstanceResponse((ResponseMessageType)aggregatedResponse, (MasterInstanceResultResponseType)master);
        aggregatedResponse.setResponseHeader(new ResponseHeaderType(HiveCommonSerializer.getResultStatusDone((String)"DONE")));
        if (DEBUG) {
            log.debug((Object)("Completed:" + this.siteResponsesCompleted.size()));
        }
        if (DEBUG) {
            log.debug((Object)("Errors:" + this.siteResponsesError.size()));
        }
        return aggregatedResponse;
    }

    private static QueryResultInstanceType getAggregateSummary(String shrineQueryID, int setSize) {
        QueryResultInstanceType summary = new QueryResultInstanceType();
        QueryResultTypeType result = new QueryResultTypeType();
        QueryStatusTypeType status = new QueryStatusTypeType();
        result.setDescription("AGGREGATED");
        result.setName("PATIENT_COUNT_XML");
        result.setResultTypeId("4");
        result.setDisplayType("CATNUM");
        result.setVisualAttributeType("LA");
        status.setDescription("FINISHED");
        status.setName("FINISHED");
        status.setStatusTypeId("3");
        summary.setResultInstanceId("0");
        summary.setQueryResultType(result);
        summary.setQueryStatusType(status);
        summary.setQueryInstanceId(shrineQueryID);
        summary.setSetSize(setSize);
        summary.setDescription("aggregated");
        return summary;
    }

    public Integer getTotalSetSize() {
        return this.setSize;
    }

    public List<ResponseMessageType> getCompleted() {
        return Collections.unmodifiableList(this.siteResponsesCompleted);
    }

    public List<ResponseMessageType> getErrors() {
        return Collections.unmodifiableList(this.siteResponsesError);
    }
}

